/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.tc;

import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.cryptimeleon.craco.commitment.OpenValue;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSSignature;
import org.cryptimeleon.craco.sig.sps.akot15.pos.SPSPOSVerificationKey;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.annotations.AnnotatedUbrUtil;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class TCAKOT15OpenValue
implements OpenValue {
    @Represented(restorer="G1")
    protected GroupElement group1ElementGamma;
    @Represented
    protected SPSPOSVerificationKey spsPosVerificationKey;
    @Represented(restorer="[G1]")
    protected GroupElement[] spsPosOTVerificationKeys;
    @Represented
    protected SPSPOSSignature[] spsPosSignatures;

    public TCAKOT15OpenValue(GroupElement group1ElementGamma, SPSPOSVerificationKey verificationKey, GroupElement[] oneTimeVerificationKeys, SPSPOSSignature[] signatures) {
        this.group1ElementGamma = group1ElementGamma;
        this.spsPosVerificationKey = verificationKey;
        this.spsPosOTVerificationKeys = oneTimeVerificationKeys;
        this.spsPosSignatures = signatures;
    }

    public TCAKOT15OpenValue(Group g1, Group g2, Representation repr) {
        ObjectRepresentation objRepr = (ObjectRepresentation)repr;
        this.group1ElementGamma = g1.restoreElement(objRepr.get("tcgOpen"));
        this.spsPosVerificationKey = new SPSPOSVerificationKey(objRepr.get("posVk"), g1);
        this.spsPosOTVerificationKeys = (GroupElement[])g1.restoreVector(objRepr.get("posOtVk")).stream().toArray(GroupElement[]::new);
        this.spsPosSignatures = (SPSPOSSignature[])objRepr.get("posSigmas").list().stream().map(x -> new SPSPOSSignature((Representation)x, g2)).toArray(SPSPOSSignature[]::new);
    }

    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        return AnnotatedUbrUtil.autoAccumulate((ByteAccumulator)accumulator, (Object)this);
    }

    public Representation getRepresentation() {
        ObjectRepresentation objRepr = new ObjectRepresentation();
        objRepr.put("tcgOpen", this.group1ElementGamma.getRepresentation());
        objRepr.put("posVk", this.spsPosVerificationKey.getRepresentation());
        objRepr.put("posOtVk", (Representation)new ListRepresentation((Representation[])((Stream)Arrays.stream(this.spsPosOTVerificationKeys).sequential()).map(x -> x.getRepresentation()).toArray(Representation[]::new)));
        objRepr.put("posSigmas", (Representation)new ListRepresentation((Representation[])((Stream)Arrays.stream(this.spsPosSignatures).sequential()).map(x -> x.getRepresentation()).toArray(Representation[]::new)));
        return objRepr;
    }

    public SPSPOSVerificationKey getSpsPosVerificationKey() {
        return this.spsPosVerificationKey;
    }

    public void setSpsPosVerificationKey(SPSPOSVerificationKey spsPosVerificationKey) {
        this.spsPosVerificationKey = spsPosVerificationKey;
    }

    public GroupElement[] getSpsPosOTVerificationKeys() {
        return this.spsPosOTVerificationKeys;
    }

    public void setSpsPosOTVerificationKeys(GroupElement[] spsPosOTVerificationKeys) {
        this.spsPosOTVerificationKeys = spsPosOTVerificationKeys;
    }

    public SPSPOSSignature[] getSpsPosSignatures() {
        return this.spsPosSignatures;
    }

    public void setSpsPosSignatures(SPSPOSSignature[] spsPosSignatures) {
        this.spsPosSignatures = spsPosSignatures;
    }

    public GroupElement getGroup1ElementGamma() {
        return this.group1ElementGamma;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TCAKOT15OpenValue that = (TCAKOT15OpenValue)o;
        return Objects.equals(this.group1ElementGamma, that.group1ElementGamma) && Objects.equals(this.spsPosVerificationKey, that.spsPosVerificationKey) && Arrays.equals(this.spsPosOTVerificationKeys, that.spsPosOTVerificationKeys) && Arrays.equals(this.spsPosSignatures, that.spsPosSignatures);
    }

    public int hashCode() {
        int result = Objects.hash(this.group1ElementGamma, this.spsPosVerificationKey);
        result = 31 * result + Arrays.hashCode(this.spsPosOTVerificationKeys);
        result = 31 * result + Arrays.hashCode(this.spsPosSignatures);
        return result;
    }
}

