/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.tcgamma;

import java.util.Objects;
import org.cryptimeleon.craco.commitment.Commitment;
import org.cryptimeleon.craco.commitment.CommitmentPair;
import org.cryptimeleon.craco.commitment.CommitmentScheme;
import org.cryptimeleon.craco.commitment.OpenValue;
import org.cryptimeleon.craco.common.plaintexts.GroupElementPlainText;
import org.cryptimeleon.craco.common.plaintexts.MessageBlock;
import org.cryptimeleon.craco.common.plaintexts.PlainText;
import org.cryptimeleon.craco.common.plaintexts.RingElementPlainText;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15Commitment;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15CommitmentKey;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15OpenValue;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15XSIGCommitment;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15XSIGCommitmentKey;
import org.cryptimeleon.craco.sig.sps.akot15.tcgamma.TCGAKOT15XSIGPublicParameters;
import org.cryptimeleon.math.serialization.ObjectRepresentation;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.cartesian.Vector;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class TCGAKOT15CommitmentScheme
implements CommitmentScheme {
    @Represented
    public AKOT15SharedPublicParameters pp;
    private TCGAKOT15CommitmentKey commitmentKey;

    public TCGAKOT15CommitmentScheme(AKOT15SharedPublicParameters pp) {
        this.pp = pp;
        this.commitmentKey = this.generateKey();
    }

    public TCGAKOT15CommitmentScheme(Representation repr) {
        ObjectRepresentation objRepr = (ObjectRepresentation)repr;
        this.pp = ((RepresentableRepresentation)objRepr.get("pp")).getRepresentedTypeName().equals(TCGAKOT15XSIGPublicParameters.class.getName()) ? new TCGAKOT15XSIGPublicParameters(((RepresentableRepresentation)objRepr.get("pp")).getRepresentation()) : new AKOT15SharedPublicParameters(((RepresentableRepresentation)objRepr.get("pp")).getRepresentation());
        this.commitmentKey = ((RepresentableRepresentation)objRepr.get("ck")).getRepresentedTypeName().equals(TCGAKOT15XSIGCommitmentKey.class.getName()) ? new TCGAKOT15XSIGCommitmentKey(this.pp.getG2GroupGenerator().getStructure(), ((RepresentableRepresentation)objRepr.get("ck")).getRepresentation()) : new TCGAKOT15CommitmentKey(this.pp.getG2GroupGenerator().getStructure(), ((RepresentableRepresentation)objRepr.get("ck")).getRepresentation());
    }

    private TCGAKOT15CommitmentKey generateKey() {
        GroupElement[] group2ElementsXi = new GroupElement[this.pp.getMessageLength().intValue()];
        if (this.pp instanceof TCGAKOT15XSIGPublicParameters) {
            TCGAKOT15XSIGPublicParameters ppXSIG = (TCGAKOT15XSIGPublicParameters)this.pp;
            GroupElement[] group2ElementsXi2 = new GroupElement[this.pp.getMessageLength().intValue()];
            GroupElement[] group2ElementsXi3 = new GroupElement[this.pp.getMessageLength().intValue()];
            for (int i = 0; i < group2ElementsXi.length; ++i) {
                Zp.ZpElement rho = this.pp.getZp().getUniformlyRandomElement();
                group2ElementsXi[i] = this.pp.getG2GroupGenerator().pow((Zn.ZnElement)rho).compute();
                group2ElementsXi2[i] = ppXSIG.getGroup2ElementF2().pow((Zn.ZnElement)rho).compute();
                group2ElementsXi3[i] = ppXSIG.getGroup2ElementU1().pow((Zn.ZnElement)rho).compute();
            }
            return new TCGAKOT15XSIGCommitmentKey(group2ElementsXi, group2ElementsXi2, group2ElementsXi3);
        }
        for (int i = 0; i < group2ElementsXi.length; ++i) {
            group2ElementsXi[i] = this.pp.getG2GroupGenerator().pow((Zn.ZnElement)this.pp.getZp().getUniformlyRandomElement()).compute();
        }
        return new TCGAKOT15CommitmentKey(group2ElementsXi);
    }

    @Override
    public CommitmentPair commit(PlainText plainText) {
        this.doMessageChecks(plainText, true);
        MessageBlock messageBlock = (MessageBlock)plainText;
        Zp.ZpElement zeta = this.pp.getZp().getUniformlyRandomElement();
        TCGAKOT15OpenValue open = new TCGAKOT15OpenValue(this.pp.getG1GroupGenerator().pow((Zn.ZnElement)zeta).compute());
        if (this.pp instanceof TCGAKOT15XSIGPublicParameters) {
            return this.commitXSIGVariant(messageBlock, zeta, open);
        }
        GroupElement group2ElementGu = this.pp.getG2GroupGenerator().pow((Zn.ZnElement)zeta);
        for (int i = 0; i < messageBlock.length(); ++i) {
            GroupElement Xi = this.commitmentKey.getGroup2ElementsXi()[i];
            RingElement mi = ((RingElementPlainText)messageBlock.get(i)).getRingElement();
            group2ElementGu = group2ElementGu.op((Element)Xi.pow(mi));
        }
        group2ElementGu.compute();
        return new CommitmentPair(new TCGAKOT15Commitment(group2ElementGu), open);
    }

    private CommitmentPair commitXSIGVariant(MessageBlock messageBlock, Zp.ZpElement zeta, TCGAKOT15OpenValue open) {
        TCGAKOT15XSIGCommitmentKey ck = (TCGAKOT15XSIGCommitmentKey)this.commitmentKey;
        TCGAKOT15XSIGPublicParameters ppXSIG = (TCGAKOT15XSIGPublicParameters)this.pp;
        GroupElement group2ElementGu = this.pp.getG2GroupGenerator().pow((Zn.ZnElement)zeta);
        GroupElement group2ElementGu2 = ppXSIG.getGroup2ElementF2().pow((Zn.ZnElement)zeta);
        GroupElement group2ElementGu3 = ppXSIG.getGroup2ElementU1().pow((Zn.ZnElement)zeta);
        for (int i = 0; i < messageBlock.length(); ++i) {
            RingElement mi = ((RingElementPlainText)messageBlock.get(i)).getRingElement();
            GroupElement Xi = ck.getGroup2ElementsXi()[i];
            GroupElement Xi2 = ck.getGroup2ElementsXi2()[i];
            GroupElement Xi3 = ck.getGroup2ElementsXi3()[i];
            group2ElementGu = group2ElementGu.op((Element)Xi.pow(mi));
            group2ElementGu2 = group2ElementGu2.op((Element)Xi2.pow(mi));
            group2ElementGu3 = group2ElementGu3.op((Element)Xi3.pow(mi));
        }
        group2ElementGu.compute();
        group2ElementGu2.compute();
        group2ElementGu3.compute();
        return new CommitmentPair(new TCGAKOT15XSIGCommitment(group2ElementGu, group2ElementGu2, group2ElementGu3), open);
    }

    @Override
    public boolean verify(Commitment commitment, OpenValue openValue, PlainText plainText) {
        this.doMessageChecks(plainText, false);
        if (!(commitment instanceof TCGAKOT15Commitment)) {
            throw new IllegalArgumentException("this is not a valid commitment for this scheme");
        }
        if (!(openValue instanceof TCGAKOT15OpenValue)) {
            throw new IllegalArgumentException("this is not a valid opening for this scheme");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        TCGAKOT15Commitment com = (TCGAKOT15Commitment)commitment;
        TCGAKOT15OpenValue open = (TCGAKOT15OpenValue)openValue;
        if (!this.pp.getMessageLength().equals(messageBlock.length())) {
            throw new IllegalArgumentException(String.format("public parameters do not match given message length : %d vs. %d", this.pp.getMessageLength(), messageBlock.length()));
        }
        GroupElement[] messageGroupElements = new GroupElement[messageBlock.length()];
        if (messageBlock.get(0) instanceof RingElementPlainText) {
            messageGroupElements = (GroupElement[])messageBlock.stream().map(x -> this.pp.getG1GroupGenerator().pow(((RingElementPlainText)x).getRingElement()).compute()).toArray(GroupElement[]::new);
        } else if (messageBlock.get(0) instanceof GroupElementPlainText) {
            messageGroupElements = (GroupElement[])messageBlock.stream().map(x -> ((GroupElementPlainText)x).get()).toArray(GroupElement[]::new);
        }
        BilinearMap bMap = this.pp.getBilinearMap();
        GroupElement ppe_lhs = bMap.apply(this.pp.getG1GroupGenerator(), com.getGroup2ElementGu()).compute();
        GroupElement ppe_rhs = bMap.apply(open.getGroup1ElementR(), this.pp.getG2GroupGenerator());
        for (int i = 0; i < messageBlock.length(); ++i) {
            ppe_rhs = ppe_rhs.op((Element)bMap.apply(messageGroupElements[i], this.commitmentKey.getGroup2ElementsXi()[i]));
        }
        ppe_rhs.compute();
        return ppe_lhs.equals(ppe_rhs);
    }

    private void doMessageChecks(PlainText plainText, boolean requireZpElements) {
        if (!(plainText instanceof MessageBlock)) {
            throw new IllegalArgumentException("The scheme requires its messages to a MessageBlock");
        }
        MessageBlock messageBlock = (MessageBlock)plainText;
        if (messageBlock.length() != this.pp.getMessageLength().intValue()) {
            throw new IllegalArgumentException(String.format("The scheme expected a message of length %d, but the size was: %d", this.pp.getMessageLength(), messageBlock.length()));
        }
        if (!requireZpElements && messageBlock.get(0) instanceof RingElementPlainText) {
            requireZpElements = true;
        }
        if (requireZpElements) {
            for (int i = 0; i < messageBlock.length(); ++i) {
                if (!(messageBlock.get(i) instanceof RingElementPlainText)) {
                    throw new IllegalArgumentException(String.format("The scheme expected its Messages to contain RingElements, but element %d was of type: %s", i, ((PlainText)messageBlock.get(i)).getClass().toString()));
                }
                RingElementPlainText ringElementPT = (RingElementPlainText)messageBlock.get(i);
                if (ringElementPT.getRingElement().getStructure().equals(this.pp.getZp())) continue;
                throw new IllegalArgumentException(String.format("The scheme expected RingElements in %s, but element %d was in: %s", this.pp.getZp().toString(), i, ringElementPT.getRingElement().getStructure().toString()));
            }
        } else {
            for (int i = 0; i < messageBlock.length(); ++i) {
                if (!(messageBlock.get(i) instanceof GroupElementPlainText)) {
                    throw new IllegalArgumentException(String.format("The scheme expected its Messages to contain GroupElements, but element %d was of type: %s", i, ((PlainText)messageBlock.get(i)).getClass().toString()));
                }
                GroupElementPlainText group1ElementPT = (GroupElementPlainText)messageBlock.get(i);
                if (group1ElementPT.get().getStructure().equals(this.pp.getG1GroupGenerator().getStructure())) continue;
                throw new IllegalArgumentException(String.format("The scheme expected GroupElements in %s, but element %d was in: %s", this.pp.getG1GroupGenerator().getStructure().toString(), i, group1ElementPT.get().getStructure().toString()));
            }
        }
    }

    public TCGAKOT15CommitmentKey getCommitmentKey() {
        return this.commitmentKey;
    }

    @Override
    public PlainText mapToPlaintext(byte[] bytes) {
        RingElementPlainText zero = new RingElementPlainText((RingElement)this.pp.getZp().getZeroElement());
        return new MessageBlock((Vector<? extends PlainText>)Vector.of((Object[])new RingElementPlainText[]{new RingElementPlainText((RingElement)this.pp.getZp().injectiveValueOf(bytes))}).pad((Object)zero, this.pp.getMessageLength().intValue()));
    }

    @Override
    public int getMaxNumberOfBytesForMapToPlaintext() {
        return (this.pp.getG1GroupGenerator().getStructure().size().bitLength() - 1) / 8;
    }

    @Override
    public Commitment restoreCommitment(Representation repr) {
        return new TCGAKOT15Commitment(this.pp.getG2GroupGenerator().getStructure(), repr);
    }

    @Override
    public OpenValue restoreOpenValue(Representation repr) {
        return new TCGAKOT15OpenValue(this.pp.getG1GroupGenerator().getStructure(), repr);
    }

    public Representation getRepresentation() {
        ObjectRepresentation objRepr = new ObjectRepresentation();
        objRepr.put("ck", (Representation)new RepresentableRepresentation((Representable)this.commitmentKey));
        objRepr.put("pp", (Representation)new RepresentableRepresentation((Representable)this.pp));
        return objRepr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TCGAKOT15CommitmentScheme that = (TCGAKOT15CommitmentScheme)o;
        return Objects.equals(this.pp, that.pp) && Objects.equals(this.commitmentKey, that.commitmentKey);
    }

    public int hashCode() {
        return Objects.hash(this.pp, this.commitmentKey);
    }
}

