/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.akot15.tcgamma;

import java.util.Objects;
import org.cryptimeleon.craco.sig.sps.akot15.AKOT15SharedPublicParameters;
import org.cryptimeleon.craco.sig.sps.akot15.xsig.SPSXSIGPublicParameters;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class TCGAKOT15XSIGPublicParameters
extends AKOT15SharedPublicParameters {
    @Represented(restorer="bilinearGroup::getG2")
    protected GroupElement group2ElementF2;
    @Represented(restorer="bilinearGroup::getG2")
    protected GroupElement group2ElementU1;

    public TCGAKOT15XSIGPublicParameters(SPSXSIGPublicParameters xsigPublicParameters, int messageLength) {
        super(xsigPublicParameters.getBilinearGroup(), messageLength);
        this.group1ElementG = xsigPublicParameters.getGroup1ElementF1();
        this.group2ElementH = xsigPublicParameters.getGroup2ElementF1();
        this.group2ElementF2 = xsigPublicParameters.getGroup2ElementF2();
        this.group2ElementU1 = xsigPublicParameters.getGroup2ElementsU()[0];
        this.precompute();
    }

    public TCGAKOT15XSIGPublicParameters(Representation repr) {
        super(repr);
    }

    public GroupElement getGroup2ElementF2() {
        return this.group2ElementF2;
    }

    public GroupElement getGroup2ElementU1() {
        return this.group2ElementU1;
    }

    private void precompute() {
        this.group2ElementF2.precomputePow();
        this.group2ElementU1.precomputePow();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TCGAKOT15XSIGPublicParameters that = (TCGAKOT15XSIGPublicParameters)o;
        return Objects.equals(this.group2ElementF2, that.group2ElementF2) && Objects.equals(this.group2ElementU1, that.group2ElementU1);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.group2ElementF2, this.group2ElementU1);
    }
}

