/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.craco.sig.sps.eq;

import java.util.Objects;
import org.cryptimeleon.craco.common.PublicParameters;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class SPSEQPublicParameters
implements PublicParameters {
    @Represented
    private BilinearGroup bilinearGroup;
    @Represented(restorer="bilinearGroup::getG1")
    protected GroupElement group1ElementP;
    @Represented(restorer="bilinearGroup::getG2")
    protected GroupElement group2ElementHatP;

    public SPSEQPublicParameters(BilinearGroup bilinearGroup) {
        this.bilinearGroup = bilinearGroup;
        this.group1ElementP = this.bilinearGroup.getG1().getUniformlyRandomNonNeutral();
        this.group2ElementHatP = this.bilinearGroup.getG2().getUniformlyRandomNonNeutral();
    }

    public SPSEQPublicParameters(Representation repr) {
        new ReprUtil((Object)this).deserialize(repr);
    }

    public Representation getRepresentation() {
        return ReprUtil.serialize((Object)this);
    }

    public Zp getZp() {
        return new Zp(this.bilinearGroup.getG1().size());
    }

    public BilinearMap getBilinearMap() {
        return this.bilinearGroup.getBilinearMap();
    }

    public GroupElement getGroup1ElementP() {
        return this.group1ElementP;
    }

    public GroupElement getGroup2ElementHatP() {
        return this.group2ElementHatP;
    }

    public int hashCode() {
        return Objects.hash(this.bilinearGroup);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SPSEQPublicParameters that = (SPSEQPublicParameters)other;
        return Objects.equals(this.bilinearGroup, that.bilinearGroup);
    }
}

