/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.pairings;

import java.util.Arrays;
import java.util.Collection;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.basic.BasicBilinearGroup;
import org.cryptimeleon.math.structures.groups.counting.CountingBilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular.SupersingularTateGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigBilinearGroupImpl;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PairingTests {
    private final BilinearMap pairing;

    public PairingTests(BilinearMap pairing) {
        this.pairing = pairing;
    }

    @Test
    public void testBasicProperties() {
        GroupElement t2;
        GroupElement t1;
        GroupElement p1 = this.pairing.getG1().getUniformlyRandomElement();
        GroupElement r1 = this.pairing.getG1().getUniformlyRandomElement();
        GroupElement p2 = this.pairing.getG2().getUniformlyRandomElement();
        GroupElement r2 = this.pairing.getG2().getUniformlyRandomElement();
        Zn.ZnElement randomExp1 = this.pairing.getG1().getUniformlyRandomNonzeroExponent();
        Zn.ZnElement randomExp2 = this.pairing.getG1().getUniformlyRandomNonzeroExponent();
        Assert.assertEquals((Object)p1.op((Element)r1).op((Element)r1.inv()), (Object)p1);
        Assert.assertTrue((boolean)p1.pow(this.pairing.getG1().size()).isNeutralElement());
        Assert.assertTrue((boolean)p2.pow(this.pairing.getG2().size()).isNeutralElement());
        if (this.pairing.isSymmetric()) {
            t1 = this.pairing.apply(p1, p2);
            t2 = this.pairing.apply(p2, p1);
            Assert.assertEquals((Object)t1, (Object)t2);
        }
        Assert.assertEquals((String)"Bilinearity in first argument", (Object)this.pairing.apply(p1, p2), (Object)this.pairing.apply(p1.op((Element)r1), p2).op((Element)this.pairing.apply(r1.inv(), p2)));
        t1 = this.pairing.apply(p1, p2);
        t2 = this.pairing.apply(p1, r2);
        GroupElement t3 = this.pairing.apply(p1, p2.op((Element)r2));
        GroupElement t4 = t1.op((Element)t2);
        Assert.assertEquals((Object)t4, (Object)t3);
        Assert.assertTrue((boolean)t1.pow(this.pairing.getG1().size()).isNeutralElement());
        Assertions.assertFalse((boolean)t1.isNeutralElement());
        Assert.assertTrue((String)"Bilinearity in second argument", (boolean)this.pairing.apply(r1, p2.op((Element)r2)).op((Element)this.pairing.apply(r1.inv(), p2)).op((Element)this.pairing.apply(r1.inv(), r2)).isNeutralElement());
        Assert.assertEquals((Object)this.pairing.apply(p1.pow(randomExp1), p2), (Object)this.pairing.apply(p1, p2.pow(randomExp1)));
        Assert.assertEquals((Object)this.pairing.apply(p1.pow(randomExp1), p2), (Object)this.pairing.apply(p1, p2).pow(randomExp1));
        Assert.assertEquals((Object)this.pairing.apply(p1.pow(randomExp1), p2.pow(randomExp2)), (Object)this.pairing.apply(p1, p2).pow(randomExp1.mul((Element)randomExp2)));
        Assert.assertTrue((boolean)this.pairing.apply(this.pairing.getG1().getNeutralElement(), p2).isNeutralElement());
        Assert.assertTrue((boolean)this.pairing.apply(p1, this.pairing.getG2().getNeutralElement()).isNeutralElement());
        Zn zn = new Zn(this.pairing.getG1().size());
        Zn.ZnElement x1 = zn.getUniformlyRandomElement();
        Zn.ZnElement x2 = zn.getUniformlyRandomElement();
        Assert.assertEquals((Object)this.pairing.apply(p1.pow(x1), p2.pow(x2)), (Object)this.pairing.apply(p1, p2).pow(x1.mul((Element)x2)));
    }

    @Parameterized.Parameters(name="Test: {0}")
    public static Collection<BilinearMap[]> data() {
        CountingBilinearGroup countingGroup1 = new CountingBilinearGroup(128, BilinearGroup.Type.TYPE_1);
        CountingBilinearGroup countingGroup2 = new CountingBilinearGroup(128, BilinearGroup.Type.TYPE_2);
        CountingBilinearGroup countingGroup3 = new CountingBilinearGroup(128, BilinearGroup.Type.TYPE_3);
        BasicBilinearGroup supsingGroup = new BasicBilinearGroup((BilinearGroupImpl)new SupersingularTateGroupImpl(80));
        BasicBilinearGroup bnGroup = new BasicBilinearGroup((BilinearGroupImpl)new BarretoNaehrigBilinearGroupImpl(80));
        BasicBilinearGroup sfcBn = new BasicBilinearGroup((BilinearGroupImpl)new BarretoNaehrigBilinearGroupImpl("SFC-256"));
        BilinearMap[][] params = new BilinearMap[][]{{countingGroup1.getBilinearMap()}, {countingGroup2.getBilinearMap()}, {countingGroup3.getBilinearMap()}, {supsingGroup.getBilinearMap()}, {bnGroup.getBilinearMap()}, {sfcBn.getBilinearMap()}};
        return Arrays.asList(params);
    }
}

