/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.standalone.params;

import java.math.BigInteger;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.standalone.StandaloneReprSubTest;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.RingAdditiveGroupImpl;
import org.cryptimeleon.math.structures.groups.RingUnitGroupImpl;
import org.cryptimeleon.math.structures.groups.basic.BasicBilinearGroup;
import org.cryptimeleon.math.structures.groups.cartesian.ProductGroup;
import org.cryptimeleon.math.structures.groups.counting.CountingBilinearGroup;
import org.cryptimeleon.math.structures.groups.counting.CountingBilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular.SupersingularBilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular.SupersingularTateGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigBilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigBilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.lazy.LazyBilinearGroup;
import org.cryptimeleon.math.structures.groups.sn.Sn;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.cartesian.ProductRing;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionField;
import org.cryptimeleon.math.structures.rings.polynomial.PolynomialRing;
import org.cryptimeleon.math.structures.rings.zn.HashIntoZn;
import org.cryptimeleon.math.structures.rings.zn.HashIntoZnAdditiveGroup;
import org.cryptimeleon.math.structures.rings.zn.HashIntoZp;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;

public class StructureStandaloneReprTest
extends StandaloneReprSubTest {
    private final Zn zn = new Zn(BigInteger.valueOf(100000L));
    private final Zp zp = new Zp(BigInteger.valueOf(100003L));

    public void testBilinearGroup(BilinearGroup bilGroup) {
        this.test((StandaloneRepresentable)bilGroup);
        this.test((StandaloneRepresentable)bilGroup.getG1());
        this.test((StandaloneRepresentable)bilGroup.getG2());
        this.test((StandaloneRepresentable)bilGroup.getGT());
        try {
            this.test((StandaloneRepresentable)bilGroup.getHashIntoG1());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.test((StandaloneRepresentable)bilGroup.getHashIntoG2());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.test((StandaloneRepresentable)bilGroup.getHashIntoGT());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.test((StandaloneRepresentable)bilGroup.getHomomorphismG2toG1());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testBilinearGroupImpl(BilinearGroupImpl bilGroup) {
        this.test((StandaloneRepresentable)bilGroup);
        this.test((StandaloneRepresentable)bilGroup.getG1());
        this.test((StandaloneRepresentable)bilGroup.getG2());
        this.test((StandaloneRepresentable)bilGroup.getGT());
        try {
            this.test((StandaloneRepresentable)bilGroup.getHashIntoG1());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.test((StandaloneRepresentable)bilGroup.getHashIntoG2());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.test((StandaloneRepresentable)bilGroup.getHashIntoGT());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            this.test((StandaloneRepresentable)bilGroup.getHomomorphismG2toG1());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testBarretoNaehrig() {
        this.testBilinearGroup((BilinearGroup)new BarretoNaehrigBilinearGroup(80));
        this.testBilinearGroupImpl((BilinearGroupImpl)new BarretoNaehrigBilinearGroupImpl(80));
    }

    public void testSupersingular() {
        this.testBilinearGroupImpl((BilinearGroupImpl)new SupersingularTateGroupImpl(80));
        this.testBilinearGroup((BilinearGroup)new SupersingularBilinearGroup(80));
    }

    public void testLazyAndBasicGroup() {
        CountingBilinearGroupImpl debugGroupImpl = new CountingBilinearGroupImpl(128, BilinearGroup.Type.TYPE_1);
        this.testBilinearGroup((BilinearGroup)new LazyBilinearGroup((BilinearGroupImpl)debugGroupImpl));
        this.testBilinearGroup((BilinearGroup)new BasicBilinearGroup((BilinearGroupImpl)debugGroupImpl));
    }

    public void testCountingGroup() {
        this.testBilinearGroup((BilinearGroup)new CountingBilinearGroup(128, BilinearGroup.Type.TYPE_1));
        this.testBilinearGroupImpl((BilinearGroupImpl)new CountingBilinearGroupImpl(128, BilinearGroup.Type.TYPE_1));
    }

    public void testExtensionField() {
        this.test((StandaloneRepresentable)new ExtensionField(BigInteger.valueOf(17L)));
    }

    public void testProductStructures() {
        this.test((StandaloneRepresentable)new ProductGroup(new Group[]{this.zn.asAdditiveGroup(), this.zp.asUnitGroup()}));
        this.test((StandaloneRepresentable)new ProductRing(new Ring[]{this.zp, this.zn}));
    }

    public void testRingGroups() {
        this.test((StandaloneRepresentable)this.zp.asUnitGroup());
        this.test((StandaloneRepresentable)this.zp.asAdditiveGroup());
        this.test((StandaloneRepresentable)new RingUnitGroupImpl((Ring)this.zp));
        this.test((StandaloneRepresentable)new RingAdditiveGroupImpl((Ring)this.zp));
    }

    public void testRings() {
        this.test((StandaloneRepresentable)this.zp);
        this.test((StandaloneRepresentable)this.zn);
        this.test((StandaloneRepresentable)new HashIntoZn((Zn)this.zp));
        this.test((StandaloneRepresentable)new HashIntoZp(this.zp));
        this.test((StandaloneRepresentable)new HashIntoZnAdditiveGroup((Zn)this.zp));
        this.test((StandaloneRepresentable)new PolynomialRing((Ring)this.zp));
    }

    public void testSn() {
        this.test((StandaloneRepresentable)new Sn(20));
    }
}

