/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures;

import java.math.BigInteger;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.counting.CountingBilinearGroup;
import org.cryptimeleon.math.structures.groups.counting.CountingGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class CountingTest {
    CountingBilinearGroup bilGroup;

    @Before
    public void setUp() {
        this.bilGroup = new CountingBilinearGroup(128, BilinearGroup.Type.TYPE_2);
    }

    @Test
    public void testNullInstantiation() {
        CountingGroup countingGroup = (CountingGroup)this.bilGroup.getG1();
        Assertions.assertEquals((long)0L, (long)countingGroup.getNumRetrievedRepresentations());
        Assertions.assertEquals((long)0L, (long)countingGroup.getNumExps());
        Assertions.assertEquals((long)0L, (long)countingGroup.getNumOpsTotal());
        Assertions.assertEquals((long)0L, (long)countingGroup.getNumSquaringsTotal());
        Assertions.assertEquals((long)0L, (long)countingGroup.getNumInversionsTotal());
        Assertions.assertEquals((long)0L, (long)countingGroup.getNumOpsNoExpMultiExp());
        Assertions.assertEquals((long)0L, (long)countingGroup.getNumSquaringsNoExpMultiExp());
        Assertions.assertEquals((long)0L, (long)countingGroup.getNumInversionsNoExpMultiExp());
        Assertions.assertArrayEquals((Object[])new Integer[0], (Object[])countingGroup.getMultiExpTermNumbers().toArray(new Integer[0]));
    }

    @Test
    public void testBasicOperationCounting() {
        CountingGroup countingGroup = (CountingGroup)this.bilGroup.getG1();
        GroupElement elem = countingGroup.getUniformlyRandomNonNeutral();
        GroupElement elem2 = countingGroup.getUniformlyRandomNonNeutral();
        elem.op((Element)elem).inv().computeSync();
        elem.op((Element)elem2).computeSync();
        Assertions.assertEquals((long)1L, (long)countingGroup.getNumOpsNoExpMultiExp());
        Assertions.assertEquals((long)1L, (long)countingGroup.getNumOpsTotal());
        Assertions.assertEquals((long)1L, (long)countingGroup.getNumInversionsNoExpMultiExp());
        Assertions.assertEquals((long)1L, (long)countingGroup.getNumInversionsTotal());
        Assertions.assertEquals((long)1L, (long)countingGroup.getNumSquaringsNoExpMultiExp());
        Assertions.assertEquals((long)1L, (long)countingGroup.getNumSquaringsTotal());
    }

    @Test
    public void testPowCounting() {
        CountingGroup countingGroup = (CountingGroup)this.bilGroup.getG1();
        GroupElement elem = countingGroup.getUniformlyRandomNonNeutral();
        elem.pow(10L).computeSync();
        Assertions.assertEquals((long)8L, (long)countingGroup.getNumOpsTotal());
        Assertions.assertEquals((long)2L, (long)countingGroup.getNumSquaringsTotal());
        Assertions.assertEquals((long)1L, (long)countingGroup.getNumExps());
    }

    @Test
    public void testRepresentationCounting() {
        CountingGroup countingGroup = (CountingGroup)this.bilGroup.getG1();
        GroupElement elem = countingGroup.getUniformlyRandomNonNeutral();
        elem.getRepresentation();
        elem.getRepresentation();
        Assertions.assertEquals((long)2L, (long)countingGroup.getNumRetrievedRepresentations());
    }

    @Test
    public void testPairingCounting() {
        CountingGroup groupG1 = (CountingGroup)this.bilGroup.getG1();
        CountingGroup groupG2 = (CountingGroup)this.bilGroup.getG2();
        CountingGroup groupGT = (CountingGroup)this.bilGroup.getGT();
        GroupElement elemG1 = groupG1.getUniformlyRandomNonNeutral();
        GroupElement elemG2 = groupG2.getUniformlyRandomNonNeutral();
        this.bilGroup.getBilinearMap().apply(elemG1, elemG2).computeSync();
        Assertions.assertEquals((long)1L, (long)this.bilGroup.getNumPairings());
        Assertions.assertEquals((long)0L, (long)groupG1.getNumExps());
        Assertions.assertEquals((long)0L, (long)groupG2.getNumExps());
        Assertions.assertEquals((long)0L, (long)groupGT.getNumExps());
        this.bilGroup.getBilinearMap().apply(elemG1, elemG2, BigInteger.TEN).computeSync();
        Assertions.assertEquals((long)2L, (long)this.bilGroup.getNumPairings());
        Assertions.assertEquals((long)8L, (long)groupGT.getNumOpsTotal());
        Assertions.assertEquals((long)2L, (long)groupGT.getNumSquaringsTotal());
        Assertions.assertEquals((long)1L, (long)groupGT.getNumExps());
    }

    @Test
    public void testMultiExpCounting() {
        GroupElement elem3;
        GroupElement elem2;
        GroupElement elem1;
        CountingGroup countingGroup = (CountingGroup)this.bilGroup.getG1();
        do {
            elem1 = countingGroup.getUniformlyRandomNonNeutral();
            elem2 = countingGroup.getUniformlyRandomNonNeutral();
            elem3 = countingGroup.getUniformlyRandomNonNeutral();
        } while (elem1.equals(elem2) || elem2.equals(elem3) || elem3.equals(elem1));
        elem1.pow(10L).op((Element)elem2.pow(10L)).op((Element)elem3.pow(10L)).computeSync();
        System.out.println(countingGroup.formatCounterData());
        Assertions.assertArrayEquals((Object[])new Integer[]{3}, (Object[])countingGroup.getMultiExpTermNumbers().toArray(new Integer[1]));
        Assertions.assertEquals((long)24L, (long)countingGroup.getNumOpsTotal());
        Assertions.assertEquals((long)4L, (long)countingGroup.getNumSquaringsTotal());
    }

    @Test
    public void testComputeWorksSynchronously() {
        CountingGroup countingGroup = (CountingGroup)this.bilGroup.getG1();
        GroupElement elem = countingGroup.getUniformlyRandomNonNeutral();
        elem.op((Element)elem).inv().compute();
        Assertions.assertEquals((long)1L, (long)countingGroup.getNumSquaringsNoExpMultiExp());
    }

    @Test
    public void testResetCounters() {
        CountingGroup groupG1 = (CountingGroup)this.bilGroup.getG1();
        CountingGroup groupG2 = (CountingGroup)this.bilGroup.getG2();
        GroupElement elem1 = groupG1.getUniformlyRandomNonNeutral();
        GroupElement elem2 = groupG1.getUniformlyRandomNonNeutral();
        GroupElement elem3 = groupG1.getUniformlyRandomNonNeutral();
        elem1.pow(10L).op((Element)elem2.pow(10L)).op((Element)elem3.pow(10L)).computeSync();
        GroupElement elemG1 = groupG1.getUniformlyRandomNonNeutral();
        GroupElement elemG2 = groupG2.getUniformlyRandomNonNeutral();
        this.bilGroup.getBilinearMap().apply(elemG1, elemG2, BigInteger.TEN).computeSync();
        elem1.op((Element)elem2).inv().computeSync();
        elem1.getRepresentation();
        this.bilGroup.resetCounters();
        Assertions.assertEquals((long)0L, (long)groupG1.getNumRetrievedRepresentations());
        Assertions.assertEquals((long)0L, (long)groupG1.getNumExps());
        Assertions.assertEquals((long)0L, (long)groupG1.getNumOpsTotal());
        Assertions.assertEquals((long)0L, (long)groupG1.getNumSquaringsTotal());
        Assertions.assertEquals((long)0L, (long)groupG1.getNumInversionsTotal());
        Assertions.assertEquals((long)0L, (long)groupG1.getNumOpsNoExpMultiExp());
        Assertions.assertEquals((long)0L, (long)groupG1.getNumSquaringsNoExpMultiExp());
        Assertions.assertEquals((long)0L, (long)groupG1.getNumInversionsNoExpMultiExp());
        Assertions.assertArrayEquals((Object[])new Integer[0], (Object[])groupG1.getMultiExpTermNumbers().toArray(new Integer[0]));
        Assertions.assertEquals((long)0L, (long)this.bilGroup.getNumPairings());
    }

    @Test
    public void testCountingHomomorphism() {
        CountingGroup groupG1 = (CountingGroup)this.bilGroup.getG1();
        CountingGroup groupG2 = (CountingGroup)this.bilGroup.getG2();
        GroupElement elemG2 = groupG2.getUniformlyRandomNonNeutral();
        GroupElement elemG1 = (GroupElement)this.bilGroup.getHomomorphismG2toG1().apply((Object)elemG2);
        Assertions.assertEquals((Object)elemG1.getStructure(), (Object)groupG1);
    }
}

