/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.Representable;
import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.GroupImpl;
import org.cryptimeleon.math.structures.groups.RingAdditiveGroupImpl;
import org.cryptimeleon.math.structures.groups.RingUnitGroupImpl;
import org.cryptimeleon.math.structures.groups.counting.CountingGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.nopairing.Secp256k1;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigBilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.sn.Sn;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.integers.IntegerElement;
import org.cryptimeleon.math.structures.rings.integers.IntegerRing;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class GroupImplTests {
    protected GroupImpl groupImpl;
    protected Supplier<GroupElementImpl> elementSupplier;

    public GroupImplTests(TestParams params) {
        this.groupImpl = params.group;
        this.elementSupplier = params.elementSupplier;
    }

    @Test
    public void testBasicProperties() {
        GroupElementImpl a = null;
        GroupElementImpl b = null;
        try {
            a = this.groupImpl.getUniformlyRandomElement();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof UnsupportedOperationException));
        }
        try {
            a = this.groupImpl.getUniformlyRandomNonNeutral();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof UnsupportedOperationException));
        }
        a = this.elementSupplier.get();
        b = this.elementSupplier.get();
        GroupElementImpl c = this.elementSupplier.get();
        Assert.assertTrue((boolean)a.inv().op(a).equals(this.groupImpl.getNeutralElement()));
        Assert.assertTrue((boolean)a.op(a.inv()).equals(this.groupImpl.getNeutralElement()));
        Assert.assertTrue((boolean)a.op(b).op(c).equals(a.op(b.op(c))));
        if (this.groupImpl.isCommutative()) {
            Assert.assertEquals((String)"Commutativity", (Object)a.op(b), (Object)b.op(a));
        }
        BigInteger exponent = BigInteger.TEN;
        if (this.groupImpl.isCommutative()) {
            Assert.assertEquals((String)"Exponentiation+Commutativity", (Object)a.op(b).pow(exponent), (Object)a.pow(exponent).op(b.pow(exponent)));
        }
        Assert.assertTrue((boolean)a.op(this.groupImpl.getNeutralElement()).equals(a));
        Assert.assertTrue((boolean)this.groupImpl.getNeutralElement().op(a).equals(a));
        GroupElementImpl aToTheFifth = a.op(a).op(a).op(a).op(a);
        Assert.assertEquals((String)"Exponentiation", (Object)a.pow(BigInteger.valueOf(5L)), (Object)aToTheFifth);
        Assert.assertEquals((String)"Exponentiation with negative exponent", (Object)a.pow(BigInteger.valueOf(-5L)), (Object)aToTheFifth.inv());
        BigInteger size = null;
        try {
            size = this.groupImpl.size();
            Assert.assertTrue((size == null || size.signum() >= 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
        }
        if (size != null) {
            Assert.assertTrue((String)"Lagrange", (boolean)a.pow(size).isNeutralElement());
            Assert.assertTrue((String)"Lagrange inversion", (boolean)a.pow(size.subtract(BigInteger.ONE)).equals(a.inv()));
            BigInteger r = new Zn(this.groupImpl.size()).getUniformlyRandomElement().getInteger();
            if (size.isProbablePrime(100)) {
                Assert.assertTrue((boolean)a.op(b).pow(r).op(b.pow(r.negate())).equals(a.pow(r)));
            } else {
                Assert.assertTrue((boolean)a.pow(r).op(b.pow(r)).op(b.pow(r.negate())).equals(a.pow(r)));
            }
        }
    }

    @Test
    public void testEqualsAndHashCode() {
        GroupElementImpl b;
        GroupElementImpl a = this.elementSupplier.get();
        if (a == (b = a.op(a).op(a.inv()))) {
            System.out.println("Warning: could not test hash code implementation for " + this.groupImpl);
        }
        Assert.assertTrue((a.equals(b) && b.equals(a) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Equal elements should have the same hashCode", (a.hashCode() == b.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testUniqueRepresentations() {
        Optional ubrLength = Optional.empty();
        try {
            ubrLength = this.groupImpl.getUniqueByteLength();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
        }
        if (ubrLength.isPresent()) {
            GroupElementImpl a = this.elementSupplier.get();
            GroupElementImpl b = this.elementSupplier.get();
            try {
                Assert.assertEquals((String)"ubr length", (long)((Integer)ubrLength.get()).intValue(), (long)a.getUniqueByteRepresentation().length);
                Assert.assertEquals((String)"ubr length", (long)((Integer)ubrLength.get()).intValue(), (long)b.getUniqueByteRepresentation().length);
                Assert.assertTrue((String)"Uniqueness", (a.equals(b) || !Arrays.equals(a.getUniqueByteRepresentation(), b.getUniqueByteRepresentation()) ? 1 : 0) != 0);
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
            }
        }
    }

    @Parameterized.Parameters(name="Test: {0}")
    public static Collection<TestParams[]> data() {
        RingUnitGroupImpl ringUnitGroupImpl = new RingUnitGroupImpl((Ring)new Zp(BigInteger.valueOf(13L)));
        RingAdditiveGroupImpl ringAddGroup = new RingAdditiveGroupImpl((Ring)new Zn(BigInteger.valueOf(12L)));
        RingAdditiveGroupImpl ringAddGroupInt = new RingAdditiveGroupImpl((Ring)new IntegerRing());
        CountingGroupImpl countingGroupImpl = new CountingGroupImpl("Testgroup", BigInteger.valueOf(1000L));
        BarretoNaehrigBilinearGroupImpl bnGroup = new BarretoNaehrigBilinearGroupImpl(128);
        GroupImpl bnG1 = bnGroup.getG1();
        GroupImpl bnG2 = bnGroup.getG2();
        GroupImpl bnGT = bnGroup.getGT();
        BarretoNaehrigBilinearGroupImpl bnGroup2 = new BarretoNaehrigBilinearGroupImpl(128);
        GroupImpl bnG12 = bnGroup2.getG1();
        GroupImpl bnG22 = bnGroup2.getG2();
        GroupImpl bnGT2 = bnGroup2.getGT();
        Sn sn = new Sn(10);
        TestParams[][] params = new TestParams[][]{{new TestParams((GroupImpl)ringUnitGroupImpl)}, {new TestParams((GroupImpl)ringAddGroup)}, {new TestParams((GroupImpl)ringAddGroupInt, () -> {
            RingAdditiveGroupImpl ringAdditiveGroupImpl = ringAddGroupInt;
            ringAdditiveGroupImpl.getClass();
            return new RingAdditiveGroupImpl.RingAdditiveGroupElementImpl(ringAdditiveGroupImpl, (RingElement)new IntegerElement((long)RandomGenerator.getRandomNumber((int)100000)));
        })}, {new TestParams((GroupImpl)sn)}, {new TestParams((GroupImpl)countingGroupImpl)}, {new TestParams(bnG1)}, {new TestParams(bnG2)}, {new TestParams(bnGT)}, {new TestParams(bnG12)}, {new TestParams(bnG22)}, {new TestParams(bnGT2)}, {new TestParams((GroupImpl)new Secp256k1())}};
        return Arrays.asList(params);
    }

    @Test
    public void testStructureRepresentation() {
        RepresentableRepresentation repr = new RepresentableRepresentation((Representable)this.groupImpl);
        GroupImpl s2 = (GroupImpl)repr.recreateRepresentable();
        Assert.assertEquals((String)"Reserialized GroupImpl should be equal to original", (Object)this.groupImpl, (Object)s2);
        Assert.assertEquals((String)"Reserialized GroupImpl's hashCode should be equal to original", (long)this.groupImpl.hashCode(), (long)s2.hashCode());
    }

    @Test
    public void testElementRepresentation() {
        GroupElementImpl elem = this.elementSupplier.get();
        Representation repr = elem.getRepresentation();
        GroupElementImpl elem2 = this.groupImpl.restoreElement(repr);
        Assert.assertEquals((String)"Reserialized element should be equal to original", (Object)elem, (Object)elem2);
        Assert.assertEquals((String)"Reserialized element's hashCode should be equal to original", (long)elem.hashCode(), (long)elem2.hashCode());
    }

    protected static class TestParams {
        GroupImpl group;
        Supplier<GroupElementImpl> elementSupplier;

        public TestParams(GroupImpl group, Supplier<GroupElementImpl> elementSupplier) {
            this.group = group;
            this.elementSupplier = elementSupplier;
        }

        public TestParams(GroupImpl group) {
            this(group, () -> ((GroupImpl)group).getUniformlyRandomElement());
        }

        public String toString() {
            return this.group.getClass().getName() + " - " + this.group.toString();
        }
    }
}

