/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.Structure;
import org.cryptimeleon.math.structures.StructureTests;
import org.cryptimeleon.math.structures.rings.Field;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.integers.IntegerElement;
import org.cryptimeleon.math.structures.rings.integers.IntegerRing;
import org.cryptimeleon.math.structures.rings.polynomial.PolynomialRing;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RingTests
extends StructureTests {
    protected Ring ring;
    protected Supplier<RingElement> elementSupplier;
    protected Supplier<RingElement> unitElementSupplier;

    public RingTests(TestParams params) {
        this.ring = params.ring;
        this.elementSupplier = params.elementSupplier;
        this.unitElementSupplier = params.unitElementSupplier;
    }

    @Test
    public void testField() {
        if (!(this.ring instanceof Field)) {
            return;
        }
        Field field = (Field)this.ring;
        RingElement a = this.unitElementSupplier.get();
        RingElement b = this.unitElementSupplier.get();
        Assert.assertEquals((Object)a.mul((Element)b), (Object)b.mul((Element)a));
        try {
            FieldElement primitive = field.getPrimitiveElement();
            Assert.assertNotNull((Object)this.ring.size());
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
        }
    }

    @Test
    public void testBasicProperties() {
        RingElement a = null;
        RingElement b = null;
        try {
            a = this.ring.getUniformlyRandomUnit();
            Assert.assertTrue((boolean)a.isUnit());
            b = this.ring.getUniformlyRandomElement();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof UnsupportedOperationException));
        }
        assert (a == null || a.inv().mul((Element)a).equals(this.ring.getOneElement()));
        a = this.unitElementSupplier.get();
        b = this.elementSupplier.get();
        RingElement c = this.elementSupplier.get();
        if (b instanceof PolynomialRing.Polynomial) {
            ((PolynomialRing.Polynomial)b).evaluate((Element)((PolynomialRing)b.getStructure()).getBaseRing().getUniformlyRandomElement());
        }
        Assert.assertEquals((Object)a.mul(BigInteger.valueOf(2L)), (Object)a.add((Element)a));
        Assert.assertEquals((Object)a.inv().mul((Element)a), (Object)this.ring.getOneElement());
        Assert.assertEquals((Object)a.add((Element)a.neg()), (Object)this.ring.getZeroElement());
        Assert.assertEquals((Object)a.sub((Element)a), (Object)this.ring.getZeroElement());
        Assert.assertEquals((Object)a.add((Element)b.neg()), (Object)a.sub((Element)b));
        Assert.assertEquals((Object)a.mul((Element)b).mul((Element)c), (Object)a.mul((Element)b.mul((Element)c)));
        Assert.assertEquals((Object)a.add((Element)b).add((Element)c), (Object)a.add((Element)b.add((Element)c)));
        Assert.assertEquals((Object)a.add((Element)b).mul((Element)c), (Object)a.mul((Element)c).add((Element)b.mul((Element)c)));
        Assert.assertEquals((Object)a.add((Element)b), (Object)b.add((Element)a));
        Assert.assertEquals((Object)b.div((Element)a).mul((Element)a), (Object)b);
        Assert.assertEquals((Object)b.mul((Element)a.inv()).mul((Element)a), (Object)b);
        Assert.assertEquals((Object)b.mul((Element)this.ring.getOneElement()), (Object)b);
        Assert.assertEquals((Object)this.ring.getOneElement().mul((Element)b), (Object)b);
        Assert.assertEquals((Object)b.mul((Element)this.ring.getZeroElement()), (Object)this.ring.getZeroElement());
        Exception thrown = null;
        try {
            Assert.assertFalse((boolean)this.ring.getZeroElement().isUnit());
            this.ring.getZeroElement().inv();
        }
        catch (Exception ex) {
            thrown = ex;
        }
        Assert.assertTrue((boolean)(thrown instanceof UnsupportedOperationException));
        try {
            BigInteger characteristic = this.ring.getCharacteristic();
            if (characteristic.equals(BigInteger.ZERO)) {
                Assert.assertNull((String)"Characteristic zero should imply infinite ring size", (Object)this.ring.size());
            } else if (characteristic.compareTo(BigInteger.valueOf(50000L)) < 0) {
                RingElement x = this.ring.getZeroElement();
                for (int i = 0; i < characteristic.intValue(); ++i) {
                    x = x.add((Element)b);
                }
                Assert.assertTrue((boolean)x.isZero());
            }
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
        }
        Assert.assertEquals((Object)this.ring.getElement(0L), (Object)this.ring.getZeroElement());
        Assert.assertEquals((Object)this.ring.getElement(1L), (Object)this.ring.getOneElement());
        Assert.assertEquals((Object)this.ring.getElement(-1L), (Object)this.ring.getOneElement().neg());
        Assert.assertEquals((Object)this.ring.getElement(5L).add((Element)this.ring.getElement(8L)), (Object)this.ring.getElement(13L));
        Assert.assertEquals((Object)this.ring.getElement(5L).mul((Element)this.ring.getElement(8L)), (Object)this.ring.getElement(40L));
        try {
            BigInteger size = this.ring.size();
            BigInteger unitGroupSize = this.ring.sizeUnitGroup();
            Assert.assertTrue((unitGroupSize != null || size == null ? 1 : 0) != 0);
            if (size != null) {
                Assert.assertTrue((size.compareTo(unitGroupSize) >= 0 ? 1 : 0) != 0);
            }
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
        }
        try {
            RingElement[] result = this.ring.extendedEuclideanAlgorithm(b, c);
            result = this.ring.extendedEuclideanAlgorithm(b, c);
            Assert.assertEquals((Object)b.mul((Element)result[0]).add((Element)c.mul((Element)result[1])), (Object)result[2]);
            ArrayList result2 = this.ring.extendedEuclideanAlgorithm(Arrays.asList(b, c));
            Assert.assertEquals((Object)b.mul((Element)result2.get(0)).add((Element)c.mul((Element)result2.get(1))), result2.get(2));
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testDivideWithRemainder() {
        RingElement a = this.elementSupplier.get();
        RingElement b = this.elementSupplier.get();
        if (b.isZero()) {
            b = this.ring.getOneElement();
        }
        try {
            RingElement[] result = a.divideWithRemainder(b);
            Assert.assertEquals((Object)result[0].mul((Element)b).add((Element)result[1]), (Object)a);
            Assert.assertTrue((result[1].isZero() || result[1].getRank().compareTo(b.getRank()) < 0 ? 1 : 0) != 0);
        }
        catch (Exception e) {
            if (!(e instanceof UnsupportedOperationException)) {
                System.out.println("Test Divide remainder: Error (" + e + ") by class " + b.getClass());
                e.printStackTrace();
            }
            Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
        }
    }

    @Test
    public void testEqualsAndHashCode() {
        RingElement b;
        RingElement a = this.elementSupplier.get();
        if (a == (b = a.mul((Element)this.ring.getOneElement()))) {
            System.out.println("Warning: could not test hash code implementation for " + this.ring);
        }
        Assert.assertTrue((a.equals(b) && b.equals(b) ? 1 : 0) != 0);
        Assert.assertEquals((String)"Equal elements should have the same hashCode", (long)a.hashCode(), (long)b.hashCode());
    }

    @Test
    public void testUniqueRepresentations() {
        Optional maxLength = Optional.empty();
        try {
            maxLength = this.ring.getUniqueByteLength();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
        }
        if (maxLength.isPresent()) {
            RingElement a = this.elementSupplier.get();
            RingElement b = this.elementSupplier.get();
            try {
                Assert.assertEquals((long)a.getUniqueByteRepresentation().length, (long)((Integer)maxLength.get()).intValue());
                Assert.assertEquals((long)b.getUniqueByteRepresentation().length, (long)((Integer)maxLength.get()).intValue());
            }
            catch (Exception e) {
                Assert.assertTrue((boolean)(e instanceof UnsupportedOperationException));
            }
        }
    }

    @Parameterized.Parameters(name="Test: {0}")
    public static Collection<TestParams[]> data() {
        IntegerRing integerRing = new IntegerRing();
        Zp z13 = new Zp(BigInteger.valueOf(13L));
        Zn z4 = new Zn(BigInteger.valueOf(4L));
        PolynomialRing polyRing = new PolynomialRing((Ring)z13);
        TestParams[][] testParamsArrayArray = new TestParams[4][];
        testParamsArrayArray[0] = new TestParams[]{new TestParams((Ring)integerRing, () -> new IntegerElement(5L), () -> new IntegerElement(-1L))};
        testParamsArrayArray[1] = new TestParams[]{new TestParams((Ring)z13)};
        testParamsArrayArray[2] = new TestParams[]{new TestParams((Ring)z4, () -> z4.createZnElement(BigInteger.valueOf(2L)), () -> z4.createZnElement(BigInteger.valueOf(3L)))};
        TestParams[] testParamsArray = new TestParams[1];
        testParamsArray[0] = new TestParams((Ring)polyRing, () -> {
            PolynomialRing polynomialRing = polyRing;
            polynomialRing.getClass();
            return new PolynomialRing.Polynomial(polynomialRing, new RingElement[]{new Random().nextBoolean() ? z13.getUniformlyRandomElement() : z13.getZeroElement(), z13.getUniformlyRandomElement()});
        }, () -> ((PolynomialRing)polyRing).getUniformlyRandomUnit());
        testParamsArrayArray[3] = testParamsArray;
        TestParams[][] params = testParamsArrayArray;
        return Arrays.asList(params);
    }

    @Override
    public Structure getStructureToTest() {
        return this.ring;
    }

    @Override
    public Element getElementToTest() {
        return (Element)this.elementSupplier.get();
    }

    private static class TestParams {
        Ring ring;
        Supplier<RingElement> elementSupplier;
        Supplier<RingElement> unitElementSupplier;

        public TestParams(Ring ring, Supplier<RingElement> elementSupplier, Supplier<RingElement> unitElementSupplier) {
            this.ring = ring;
            this.elementSupplier = elementSupplier;
            this.unitElementSupplier = unitElementSupplier;
        }

        public TestParams(Ring ring) {
            this(ring, () -> ((Ring)ring).getUniformlyRandomElement(), () -> ((Ring)ring).getUniformlyRandomUnit());
        }

        public String toString() {
            return this.ring.getClass().getName() + " - " + this.ring.toString();
        }
    }
}

