/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.bool;

import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.expressions.bool.LazyBoolEvaluationResult;

public class BoolNotExpr
implements BooleanExpression {
    protected final BooleanExpression child;

    public BoolNotExpr(BooleanExpression child) {
        this.child = child;
    }

    public BooleanExpression getChild() {
        return this.child;
    }

    @Override
    public BooleanExpression substitute(Substitution substitutions) {
        return this.child.substitute(substitutions).not();
    }

    @Override
    public Boolean evaluate(Substitution substitutions) {
        return this.child.evaluate(substitutions) == false;
    }

    @Override
    public LazyBoolEvaluationResult evaluateLazy(Substitution substitutions) {
        final LazyBoolEvaluationResult childResult = this.child.evaluateLazy(substitutions);
        if (childResult.isResultKnown()) {
            return LazyBoolEvaluationResult.valueOf(!childResult.getResult());
        }
        return new LazyBoolEvaluationResult(){

            @Override
            public boolean getResult() {
                return !childResult.getResult();
            }

            @Override
            boolean isResultKnown() {
                return false;
            }
        };
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
        action.accept(this.child);
    }
}

