/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.bool;

import java.math.BigInteger;
import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.expressions.bool.LazyBoolEvaluationResult;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;

public class ExponentEqualityExpr
implements BooleanExpression {
    protected final ExponentExpr lhs;
    protected final ExponentExpr rhs;

    public ExponentEqualityExpr(ExponentExpr lhs, ExponentExpr rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public BooleanExpression substitute(Substitution substitutions) {
        return this.lhs.substitute(substitutions).isEqualTo(this.rhs.substitute(substitutions));
    }

    @Override
    public Boolean evaluate(Substitution substitutions) {
        return this.lhs.sub(this.rhs).evaluate().equals(BigInteger.ZERO);
    }

    @Override
    public LazyBoolEvaluationResult evaluateLazy(Substitution substitution) {
        return this.evaluate(substitution) != false ? LazyBoolEvaluationResult.TRUE : LazyBoolEvaluationResult.FALSE;
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
        action.accept(this.lhs);
        action.accept(this.rhs);
    }

    public ExponentExpr getLhs() {
        return this.lhs;
    }

    public ExponentExpr getRhs() {
        return this.rhs;
    }
}

