/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.bool;

import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.bool.BooleanExpression;
import org.cryptimeleon.math.expressions.bool.LazyBoolEvaluationResult;
import org.cryptimeleon.math.expressions.group.GroupElementExpression;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class GroupEqualityExpr
implements BooleanExpression {
    protected GroupElementExpression lhs;
    protected GroupElementExpression rhs;

    public GroupEqualityExpr(GroupElementExpression lhs, GroupElementExpression rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public GroupElementExpression getLhs() {
        return this.lhs;
    }

    public GroupElementExpression getRhs() {
        return this.rhs;
    }

    public Group getGroup() {
        return this.lhs.getGroup() == null ? this.rhs.getGroup() : this.lhs.getGroup();
    }

    @Override
    public BooleanExpression substitute(Substitution substitutions) {
        return this.lhs.substitute(substitutions).isEqualTo(this.rhs.substitute(substitutions));
    }

    @Override
    public Boolean evaluate(Substitution substitutions) {
        return this.lhs.evaluate(substitutions).equals(this.rhs.evaluate(substitutions));
    }

    @Override
    public LazyBoolEvaluationResult evaluateLazy(Substitution substitution) {
        return new LazyGroupEqualityResult(this.lhs.evaluate(substitution), this.rhs.evaluate(substitution));
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
        action.accept(this.lhs);
        action.accept(this.rhs);
    }

    private static class LazyGroupEqualityResult
    extends LazyBoolEvaluationResult {
        protected final GroupElement lhs;
        protected final GroupElement rhs;

        public LazyGroupEqualityResult(GroupElement lhs, GroupElement rhs) {
            this.lhs = lhs.compute();
            this.rhs = rhs.compute();
        }

        @Override
        public boolean getResult() {
            return this.lhs.equals(this.rhs);
        }

        @Override
        public boolean isResultKnown() {
            return this.lhs.isComputed() && this.rhs.isComputed();
        }
    }
}

