/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.exponent;

import java.math.BigInteger;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.VariableExpression;
import org.cryptimeleon.math.expressions.bool.ExponentEqualityExpr;
import org.cryptimeleon.math.expressions.exponent.BasicNamedExponentVariableExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentConstantExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentInvExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentMulExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentNegExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentPowExpr;
import org.cryptimeleon.math.expressions.exponent.ExponentSumExpr;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public interface ExponentExpr
extends Expression {
    @Override
    public BigInteger evaluate();

    public Zn.ZnElement evaluate(Zn var1);

    @Override
    default public BigInteger evaluate(Substitution substitutions) {
        return this.substitute(substitutions).evaluate();
    }

    default public Zn.ZnElement evaluate(Zn zn, Substitution substitutions) {
        return this.substitute(substitutions).evaluate(zn);
    }

    @Override
    default public ExponentExpr substitute(String variable, Expression substitution) {
        return (ExponentExpr)Expression.super.substitute(variable, substitution);
    }

    @Override
    default public ExponentExpr substitute(VariableExpression variable, Expression substitution) {
        return (ExponentExpr)Expression.super.substitute(variable, substitution);
    }

    @Override
    public ExponentExpr substitute(Substitution var1);

    default public ExponentExpr negate() {
        return new ExponentNegExpr(this);
    }

    default public ExponentExpr invert() {
        return new ExponentInvExpr(this);
    }

    default public ExponentExpr add(ExponentExpr other) {
        return new ExponentSumExpr(this, other);
    }

    default public ExponentExpr add(Zn.ZnElement other) {
        return this.add(other.asExponentExpression());
    }

    default public ExponentExpr add(String other) {
        return this.add(new BasicNamedExponentVariableExpr(other));
    }

    default public ExponentExpr sub(ExponentExpr other) {
        return this.add(other.negate());
    }

    default public ExponentExpr sub(Zn.ZnElement other) {
        return this.sub(other.asExponentExpression());
    }

    default public ExponentExpr sub(String other) {
        return this.sub(new BasicNamedExponentVariableExpr(other));
    }

    default public ExponentExpr mul(ExponentExpr other) {
        return new ExponentMulExpr(this, other);
    }

    default public ExponentExpr mul(BigInteger other) {
        return this.mul(new ExponentConstantExpr(other));
    }

    default public ExponentExpr mul(RingElement other) {
        return this.mul(other.asInteger());
    }

    default public ExponentExpr mul(long other) {
        return this.mul(BigInteger.valueOf(other));
    }

    default public ExponentExpr mul(String other) {
        return this.mul(new BasicNamedExponentVariableExpr(other));
    }

    default public ExponentExpr pow(ExponentExpr exponent) {
        return new ExponentPowExpr(this, exponent);
    }

    default public ExponentExpr pow(long exponent) {
        return this.pow(BigInteger.valueOf(exponent));
    }

    default public ExponentExpr pow(BigInteger exponent) {
        return this.pow(new ExponentConstantExpr(exponent));
    }

    default public ExponentExpr pow(RingElement exponent) {
        return this.pow(exponent.asInteger());
    }

    default public ExponentExpr pow(String exponent) {
        return this.pow(new BasicNamedExponentVariableExpr(exponent));
    }

    default public ExponentEqualityExpr isEqualTo(ExponentExpr other) {
        return new ExponentEqualityExpr(this, other);
    }

    default public ExponentEqualityExpr isEqualTo(Zn.ZnElement other) {
        return new ExponentEqualityExpr(this, other.asExponentExpression());
    }

    default public ExponentEqualityExpr isEqualTo(BigInteger other) {
        return new ExponentEqualityExpr(this, new ExponentConstantExpr(other));
    }

    public ExponentSumExpr linearize() throws IllegalArgumentException;
}

