/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.exponent;

import java.math.BigInteger;
import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class ExponentSumExpr
implements ExponentExpr {
    protected final ExponentExpr lhs;
    protected final ExponentExpr rhs;

    public ExponentSumExpr(ExponentExpr lhs, ExponentExpr rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public ExponentExpr getLhs() {
        return this.lhs;
    }

    public ExponentExpr getRhs() {
        return this.rhs;
    }

    @Override
    public BigInteger evaluate() {
        return this.lhs.evaluate().add(this.rhs.evaluate());
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
        action.accept(this.lhs);
        action.accept(this.rhs);
    }

    @Override
    public Zn.ZnElement evaluate(Zn zn) {
        return this.lhs.evaluate(zn).add(this.rhs.evaluate(zn));
    }

    @Override
    public ExponentExpr substitute(Substitution substitutions) {
        return this.lhs.substitute(substitutions).add(this.rhs.substitute(substitutions));
    }

    @Override
    public ExponentSumExpr linearize() throws IllegalArgumentException {
        ExponentSumExpr lhsLinearized = this.lhs.linearize();
        ExponentSumExpr rhsLinearized = this.rhs.linearize();
        return new ExponentSumExpr(lhsLinearized.getLhs().add(rhsLinearized.getLhs()), lhsLinearized.getRhs().add(rhsLinearized.getRhs()));
    }
}

