/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.expressions.group;

import java.util.function.Consumer;
import org.cryptimeleon.math.expressions.Expression;
import org.cryptimeleon.math.expressions.Substitution;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.group.AbstractGroupElementExpression;
import org.cryptimeleon.math.expressions.group.GroupElementExpression;
import org.cryptimeleon.math.structures.groups.GroupElement;

public class GroupOpExpr
extends AbstractGroupElementExpression {
    protected GroupElementExpression lhs;
    protected GroupElementExpression rhs;

    public GroupOpExpr(GroupElementExpression lhs, GroupElementExpression rhs) {
        super(lhs.getGroup() != null ? lhs.getGroup() : rhs.getGroup());
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    public GroupElement evaluate() {
        return this.lhs.evaluate().op(this.rhs.evaluate());
    }

    @Override
    public GroupElement evaluate(Substitution substitutions) {
        return this.lhs.evaluate(substitutions).op(this.rhs.evaluate(substitutions));
    }

    @Override
    public void forEachChild(Consumer<Expression> action) {
        action.accept(this.lhs);
        action.accept(this.rhs);
    }

    @Override
    public GroupElementExpression substitute(Substitution substitutions) {
        return this.lhs.substitute(substitutions).op(this.rhs.substitute(substitutions));
    }

    @Override
    public GroupOpExpr linearize() throws IllegalArgumentException {
        GroupOpExpr lhsLinear = this.lhs.linearize();
        GroupOpExpr rhsLinear = this.rhs.linearize();
        return new GroupOpExpr(lhsLinear.getLhs().op(rhsLinear.getLhs()), lhsLinear.getRhs().op(rhsLinear.getRhs()));
    }

    @Override
    public GroupOpExpr flatten(ExponentExpr exponent) {
        GroupOpExpr lhsFlat = this.lhs.flatten(exponent);
        GroupOpExpr rhsLinear = this.rhs.flatten(exponent);
        return new GroupOpExpr(lhsFlat.getLhs().evaluate().op(rhsLinear.getLhs().evaluate()).expr(), lhsFlat.getRhs().op(rhsLinear.getRhs()));
    }

    public GroupElementExpression getLhs() {
        return this.lhs;
    }

    public GroupElementExpression getRhs() {
        return this.rhs;
    }
}

