/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.converter.JSONConverter;

public class MapRepresentation
extends Representation
implements Iterable<Map.Entry<Representation, Representation>> {
    private static final long serialVersionUID = -4276829583005855044L;
    protected final HashMap<Representation, Representation> map = new HashMap();

    public MapRepresentation() {
    }

    public MapRepresentation(Map<Representation, Representation> map) {
        this.map.putAll(map);
    }

    public void put(Representation key, Representation value) {
        this.map.put(key, value);
    }

    public Map<Representation, Representation> getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    public Stream<Map.Entry<Representation, Representation>> stream() {
        return this.map.entrySet().stream();
    }

    @Override
    public Iterator<Map.Entry<Representation, Representation>> iterator() {
        return this.map.entrySet().iterator();
    }

    public void forEach(BiConsumer<Representation, Representation> consumer) {
        for (Map.Entry<Representation, Representation> e : this.getMap().entrySet()) {
            consumer.accept(e.getKey(), e.getValue());
        }
    }

    public void forEachRandomlyOrdered(BiConsumer<Representation, Representation> consumer) {
        ArrayList<Representation> keys = new ArrayList<Representation>(this.map.keySet());
        Collections.shuffle(keys);
        for (Representation key : keys) {
            consumer.accept(key, this.map.get(key));
        }
    }

    public int size() {
        return this.map.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MapRepresentation other = (MapRepresentation)obj;
        return !(this.map == null ? other.map != null : !this.map.equals(other.map));
    }

    public String toString() {
        return new JSONConverter().serialize(this);
    }
}

