/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.cartesian;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.cartesian.GroupElementVector;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.cartesian.RingElementVector;

public class Vector<X> {
    protected List<? extends X> values;

    public Vector(X ... values) {
        this(values, false);
    }

    public Vector(List<? extends X> values) {
        this(values, false);
    }

    public Vector(Vector<? extends X> values) {
        this.values = values.values;
    }

    protected Vector(X[] values, boolean isSafe) {
        this.values = isSafe ? Arrays.asList(values) : new ArrayList<X>(Arrays.asList(values));
    }

    protected Vector(List<? extends X> values, boolean isSafe) {
        this.values = isSafe ? values : new ArrayList(values);
    }

    public static <Y> Vector<Y> of(Y ... vals) {
        return new Vector<Y>(vals);
    }

    public static GroupElementVector of(GroupElement ... vals) {
        return GroupElementVector.of(vals);
    }

    public static RingElementVector of(RingElement ... vals) {
        return RingElementVector.of(vals);
    }

    public static <Y> Vector<Y> iterate(Y initialValue, Function<Y, Y> nextValue, int n) {
        return Vector.iterate(initialValue, nextValue, n, Vector::instantiateWithSafeArray);
    }

    protected static <Y, V extends Vector<Y>> V iterate(Y initialValue, Function<Y, Y> nextValue, int n, Function<List<Y>, V> vectorInstantiator) {
        ArrayList<Y> result = new ArrayList<Y>(n);
        if (n > 0) {
            result.add(initialValue);
            Y currentValue = initialValue;
            for (int i = 1; i < n; ++i) {
                currentValue = nextValue.apply(currentValue);
                result.add(currentValue);
            }
        }
        return (V)((Vector)vectorInstantiator.apply(result));
    }

    public static <Y> Vector<Y> generatePlain(Function<Integer, ? extends Y> generator, int n) {
        return Vector.generatePlain(generator, n, Vector::instantiateWithSafeArray);
    }

    public static <Y> Vector<Y> generatePlain(Supplier<? extends Y> generator, int n) {
        return Vector.generatePlain(generator, n, Vector::instantiateWithSafeArray);
    }

    public static <Y, V extends Vector<Y>> V generatePlain(Function<Integer, ? extends Y> generator, int n, Function<List<Y>, V> vectorInstantiator) {
        ArrayList<Y> result = new ArrayList<Y>(n);
        for (int i = 0; i < n; ++i) {
            result.add(generator.apply(i));
        }
        return (V)((Vector)vectorInstantiator.apply(result));
    }

    public static <Y, V extends Vector<Y>> V generatePlain(Supplier<? extends Y> generator, int n, Function<List<Y>, V> vectorInstantiator) {
        ArrayList<Y> result = new ArrayList<Y>(n);
        for (int i = 0; i < n; ++i) {
            result.add(generator.get());
        }
        return (V)((Vector)vectorInstantiator.apply(result));
    }

    protected static <Z, V extends Vector<Z>> V fromStreamPlain(Stream<? extends Z> stream, Function<List<Z>, V> vectorInstantiator) {
        return (V)((Vector)vectorInstantiator.apply(stream.collect(Collectors.toList())));
    }

    public static <Z> Vector<Z> fromStreamPlain(Stream<Z> stream) {
        return Vector.fromStreamPlain(stream, Vector::instantiateWithSafeArray);
    }

    protected <Y, Z, V extends Vector<Z>> V zip(Vector<Y> other, BiFunction<X, Y, Z> combiner, Function<List<Z>, V> vectorInstantiator) {
        if (this.values.size() != other.values.size()) {
            throw new IllegalArgumentException("Can only zip two vectors of the same length");
        }
        ArrayList<Z> result = new ArrayList<Z>(this.values.size());
        for (int i = 0; i < this.values.size(); ++i) {
            result.add(combiner.apply(this.values.get(i), other.values.get(i)));
        }
        return (V)((Vector)vectorInstantiator.apply(result));
    }

    public <Y, Z> Vector<Z> zip(Vector<Y> other, BiFunction<X, Y, Z> combiner) {
        return this.zip(other, combiner, Vector::instantiateWithSafeArray);
    }

    public <Y, V extends Vector<Y>> V map(Function<X, Y> map, Function<List<Y>, ? extends V> vectorInstantiator) {
        ArrayList<Y> result = new ArrayList<Y>(this.values.size());
        for (X value : this.values) {
            result.add(map.apply(value));
        }
        return (V)((Vector)vectorInstantiator.apply(result));
    }

    public <Y> Vector<Y> map(Function<X, Y> map) {
        return this.map(map, Vector::instantiateWithSafeArray);
    }

    public <Y, V extends Vector<Y>> V map(BiFunction<Integer, X, Y> map, Function<List<Y>, ? extends V> vectorInstantiator) {
        ArrayList<Y> result = new ArrayList<Y>(this.values.size());
        for (int i = 0; i < this.values.size(); ++i) {
            result.add(map.apply(i, this.values.get(i)));
        }
        return (V)((Vector)vectorInstantiator.apply(result));
    }

    public <Y> Vector<Y> map(BiFunction<Integer, X, Y> map) {
        return this.map(map, Vector::instantiateWithSafeArray);
    }

    public void forEach(Consumer<X> consumer) {
        for (X value : this.values) {
            consumer.accept(value);
        }
    }

    public void forEach(BiConsumer<Integer, X> consumer) {
        for (int i = 0; i < this.values.size(); ++i) {
            consumer.accept(i, this.values.get(i));
        }
    }

    public X reduce(BinaryOperator<X> combiner) {
        if (this.values.size() == 0) {
            throw new RuntimeException("Cannot reduce empty vector without explicit neutral element");
        }
        return this.reduce(combiner, null);
    }

    public X reduce(BinaryOperator<X> combiner, X neutralElement) {
        if (this.values.size() == 0) {
            return neutralElement;
        }
        if (this.values.size() == 1) {
            return this.values.get(0);
        }
        Object result = this.values.get(0);
        for (int i = 1; i < this.values.size(); ++i) {
            result = combiner.apply(result, this.values.get(i));
        }
        return result;
    }

    public <Y, Z> Z zipReduce(Vector<Y> other, BiFunction<X, Y, Z> zipMap, BinaryOperator<Z> combiner, Z neutralElement) {
        if (this.values.size() != other.values.size()) {
            throw new IllegalArgumentException("Can only zip two vectors of the same length");
        }
        if (this.values.size() == 0) {
            return neutralElement;
        }
        if (this.values.size() == 1) {
            return zipMap.apply(this.values.get(0), other.values.get(0));
        }
        Object result = zipMap.apply(this.values.get(0), other.values.get(0));
        for (int i = 1; i < this.values.size(); ++i) {
            result = combiner.apply(result, zipMap.apply(this.values.get(i), other.values.get(i)));
        }
        return result;
    }

    public <Y, Z> Z zipReduce(Vector<Y> other, BiFunction<X, Y, Z> zipMap, BinaryOperator<Z> combiner) {
        if (this.values.size() == 0) {
            throw new RuntimeException("Cannot zipReduce empty vector without explicit neutral element");
        }
        return this.zipReduce(other, zipMap, combiner, null);
    }

    public Vector<X> pad(X valueToPadWith, int desiredLength) {
        ArrayList<Object> result = new ArrayList<Object>(desiredLength);
        result.addAll(this.values);
        while (result.size() < desiredLength) {
            result.add(valueToPadWith);
        }
        return Vector.instantiateWithSafeArray(result);
    }

    public Vector<X> replace(int index, X substitute) {
        ArrayList<X> result = new ArrayList<X>(this.values);
        result.set(index, substitute);
        return Vector.instantiateWithSafeArray(result);
    }

    public Vector<X> truncate(int newLength) {
        ArrayList<? extends X> result = new ArrayList<X>(this.values.subList(0, newLength));
        return Vector.instantiateWithSafeArray(result);
    }

    public Vector<X> concatenate(Vector<? extends X> secondPart) {
        ArrayList<Object> result = new ArrayList<Object>(this.values.size() + secondPart.values.size());
        result.addAll(this.values);
        result.add(secondPart.values);
        return Vector.instantiateWithSafeArray(result);
    }

    public List<X> toList() {
        return new ArrayList<X>(this.values);
    }

    public Stream<? extends X> stream() {
        return this.values.stream();
    }

    public int length() {
        return this.values.size();
    }

    public X get(int index) {
        return this.values.get(index);
    }

    private static <Y> Vector<Y> instantiateWithSafeArray(List<Y> array) {
        return new Vector<Y>(array, true);
    }

    public String toString() {
        return this.values.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Vector)) {
            return false;
        }
        Vector vector = (Vector)o;
        return this.values.equals(vector.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }
}

