/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups;

import java.math.BigInteger;
import java.util.Optional;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.RingGroupImpl;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.RingElement;

public class RingAdditiveGroupImpl
extends RingGroupImpl {
    public RingAdditiveGroupImpl(Ring ring) {
        super(ring);
    }

    public RingAdditiveGroupImpl(Representation repr) {
        super(repr);
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return this.ring.size();
    }

    @Override
    public boolean hasPrimeSize() {
        return this.ring.hasPrimeSize();
    }

    @Override
    public double estimateCostInvPerOp() {
        return 1.0;
    }

    @Override
    public RingAdditiveGroupElementImpl getNeutralElement() {
        return new RingAdditiveGroupElementImpl(this.ring.getZeroElement());
    }

    @Override
    public RingAdditiveGroupElementImpl getUniformlyRandomElement() throws UnsupportedOperationException {
        return new RingAdditiveGroupElementImpl(this.ring.getUniformlyRandomElement());
    }

    @Override
    public RingAdditiveGroupElementImpl getGenerator() throws UnsupportedOperationException {
        if (this.hasPrimeSize() || this.size().equals(this.ring.getCharacteristic())) {
            return new RingAdditiveGroupElementImpl(this.ring.getOneElement());
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RingAdditiveGroupImpl && this.ring.equals(((RingAdditiveGroupImpl)obj).ring);
    }

    @Override
    public int hashCode() {
        return this.ring.hashCode();
    }

    @Override
    public RingGroupImpl.RingGroupElementImpl getElement(RingElement ringElement) {
        return new RingAdditiveGroupElementImpl(ringElement);
    }

    @Override
    public RingAdditiveGroupElementImpl restoreElement(Representation repr) {
        return new RingAdditiveGroupElementImpl(this.ring.restoreElement(repr));
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        return this.ring.getUniqueByteLength();
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    public class RingAdditiveGroupElementImpl
    extends RingGroupImpl.RingGroupElementImpl {
        public RingAdditiveGroupElementImpl(RingElement e) {
            super(RingAdditiveGroupImpl.this, e);
        }

        @Override
        public RingAdditiveGroupElementImpl op(GroupElementImpl e) {
            return new RingAdditiveGroupElementImpl(this.element.add(((RingAdditiveGroupElementImpl)e).element));
        }

        @Override
        public RingAdditiveGroupElementImpl pow(BigInteger exponent) {
            return new RingAdditiveGroupElementImpl(this.element.mul(exponent));
        }

        @Override
        public RingAdditiveGroupImpl getStructure() {
            return RingAdditiveGroupImpl.this;
        }

        @Override
        public RingAdditiveGroupElementImpl inv() {
            return new RingAdditiveGroupElementImpl(this.element.neg());
        }

        @Override
        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            return this.element.updateAccumulator(accumulator);
        }
    }
}

