/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups;

import org.cryptimeleon.math.serialization.RepresentableRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.GroupImpl;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.RingElement;

public abstract class RingGroupImpl
implements GroupImpl {
    protected final Ring ring;

    public RingGroupImpl(Ring ring) {
        this.ring = ring;
    }

    public RingGroupImpl(Representation repr) {
        this.ring = (Ring)repr.repr().recreateRepresentable();
    }

    public boolean equals(Object obj) {
        return obj.getClass().equals(this.getClass()) && ((RingGroupImpl)obj).ring.equals(this.ring);
    }

    public int hashCode() {
        return this.ring.hashCode();
    }

    @Override
    public Representation getRepresentation() {
        return new RepresentableRepresentation(this.ring);
    }

    public Ring getRing() {
        return this.ring;
    }

    public abstract RingGroupElementImpl getElement(RingElement var1);

    public String toString() {
        return this.ring.toString();
    }

    public abstract class RingGroupElementImpl
    implements GroupElementImpl {
        protected final RingElement element;

        public RingGroupElementImpl(RingElement e) {
            this.element = e;
        }

        public boolean equals(Object obj) {
            return obj instanceof RingGroupElementImpl && this.element.equals(((RingGroupElementImpl)obj).element);
        }

        public int hashCode() {
            return this.element.hashCode();
        }

        public RingElement projectToRing() {
            return this.element;
        }

        @Override
        public Representation getRepresentation() {
            return this.element.getRepresentation();
        }

        public String toString() {
            return this.element.toString();
        }
    }
}

