/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups;

import java.math.BigInteger;
import java.util.Optional;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.RingGroupImpl;
import org.cryptimeleon.math.structures.rings.Field;
import org.cryptimeleon.math.structures.rings.Ring;
import org.cryptimeleon.math.structures.rings.RingElement;

public class RingUnitGroupImpl
extends RingGroupImpl {
    public RingUnitGroupImpl(Ring ring) {
        super(ring);
    }

    public RingUnitGroupImpl(Representation repr) {
        super(repr);
    }

    @Override
    public RingGroupImpl.RingGroupElementImpl getElement(RingElement ringElement) {
        return new RingUnitGroupElementImpl(ringElement);
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return this.ring.sizeUnitGroup();
    }

    @Override
    public boolean hasPrimeSize() {
        return this.size().isProbablePrime(128);
    }

    @Override
    public double estimateCostInvPerOp() {
        return 0.1;
    }

    @Override
    public RingUnitGroupElementImpl getNeutralElement() {
        return new RingUnitGroupElementImpl(this.ring.getOneElement());
    }

    @Override
    public RingUnitGroupElementImpl getUniformlyRandomElement() throws UnsupportedOperationException {
        return new RingUnitGroupElementImpl(this.ring.getUniformlyRandomUnit());
    }

    @Override
    public RingUnitGroupElementImpl restoreElement(Representation repr) {
        return new RingUnitGroupElementImpl(this.ring.restoreElement(repr));
    }

    @Override
    public GroupElementImpl getGenerator() throws UnsupportedOperationException {
        if (this.ring instanceof Field) {
            return new RingUnitGroupElementImpl((RingElement)((Field)this.ring).getPrimitiveElement());
        }
        throw new UnsupportedOperationException("Cannot compute generator for this ring group " + this);
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        return this.ring.getUniqueByteLength();
    }

    @Override
    public boolean isCommutative() {
        return this.ring.isCommutative();
    }

    public class RingUnitGroupElementImpl
    extends RingGroupImpl.RingGroupElementImpl {
        public RingUnitGroupElementImpl(RingElement e) {
            super(RingUnitGroupImpl.this, e);
        }

        @Override
        public RingUnitGroupElementImpl op(GroupElementImpl e) {
            return new RingUnitGroupElementImpl(this.element.mul(((RingUnitGroupElementImpl)e).element));
        }

        @Override
        public RingUnitGroupElementImpl pow(BigInteger exponent) {
            return new RingUnitGroupElementImpl(this.element.pow(exponent));
        }

        @Override
        public RingUnitGroupImpl getStructure() {
            return RingUnitGroupImpl.this;
        }

        @Override
        public RingUnitGroupElementImpl inv() {
            return new RingUnitGroupElementImpl(this.element.inv());
        }

        @Override
        public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
            return this.element.updateAccumulator(accumulator);
        }
    }
}

