/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.counting;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.counting.CountingBilinearMapImpl;
import org.cryptimeleon.math.structures.groups.counting.CountingGroupImpl;
import org.cryptimeleon.math.structures.groups.counting.CountingIsomorphismImpl;
import org.cryptimeleon.math.structures.groups.counting.HashIntoCountingGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMapImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.GroupHomomorphismImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;

public class CountingBilinearGroupImpl
implements BilinearGroupImpl {
    @Represented
    protected Integer securityParameter;
    @Represented
    protected BilinearGroup.Type pairingType;
    @Represented
    protected BigInteger size;
    @Represented
    protected Boolean enableExpCounting;
    @Represented
    protected Boolean enableMultiExpCounting;
    CountingBilinearMapImpl bilinearMapImpl;

    public CountingBilinearGroupImpl(int securityParameter, BilinearGroup.Type pairingType, int numPrimeFactors, boolean enableExpCounting, boolean enableMultiExpCounting) {
        this.securityParameter = securityParameter;
        this.pairingType = pairingType;
        this.enableExpCounting = enableExpCounting;
        this.enableMultiExpCounting = enableMultiExpCounting;
        ArrayList<BigInteger> primeFactors = new ArrayList<BigInteger>();
        for (int i = 0; i < numPrimeFactors; ++i) {
            primeFactors.add(RandomGenerator.getRandomPrime(securityParameter));
        }
        this.size = primeFactors.stream().reduce(BigInteger.ONE, BigInteger::multiply);
        this.init();
    }

    public CountingBilinearGroupImpl(int securityParameter, BilinearGroup.Type pairingType, int numPrimeFactors) {
        this(securityParameter, pairingType, numPrimeFactors, false, false);
    }

    public CountingBilinearGroupImpl(int securityParameter, BilinearGroup.Type pairingType) {
        this(securityParameter, pairingType, 1);
    }

    public CountingBilinearGroupImpl(int securityParameter, BilinearGroup.Type pairingType, BigInteger size, boolean enableExpCounting, boolean enableMultiExpCounting) {
        this.securityParameter = securityParameter;
        this.pairingType = pairingType;
        this.enableExpCounting = enableExpCounting;
        this.enableMultiExpCounting = enableMultiExpCounting;
        this.size = size;
        this.init();
    }

    protected void init() {
        this.bilinearMapImpl = new CountingBilinearMapImpl(this.pairingType, this.size, this.enableExpCounting, this.enableMultiExpCounting);
    }

    public CountingBilinearGroupImpl(Representation repr) {
        ReprUtil.deserialize(this, repr);
        this.init();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CountingBilinearGroupImpl that = (CountingBilinearGroupImpl)other;
        return Objects.equals((Object)this.pairingType, (Object)that.pairingType) && Objects.equals(this.size, that.size) && Objects.equals(this.enableExpCounting, that.enableExpCounting) && Objects.equals(this.enableMultiExpCounting, that.enableMultiExpCounting);
    }

    public int hashCode() {
        return Objects.hash(this.pairingType.ordinal(), this.size);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    @Override
    public CountingGroupImpl getG1() {
        return this.bilinearMapImpl.g1;
    }

    @Override
    public CountingGroupImpl getG2() {
        return this.bilinearMapImpl.g2;
    }

    @Override
    public CountingGroupImpl getGT() {
        return this.bilinearMapImpl.gt;
    }

    @Override
    public BilinearMapImpl getBilinearMap() {
        return this.bilinearMapImpl;
    }

    @Override
    public GroupHomomorphismImpl getHomomorphismG2toG1() throws UnsupportedOperationException {
        if (this.pairingType != BilinearGroup.Type.TYPE_1 && this.pairingType != BilinearGroup.Type.TYPE_2) {
            throw new UnsupportedOperationException("Didn't require existence of a group homomorphism");
        }
        return new CountingIsomorphismImpl(this.getG2(), this.getG1());
    }

    @Override
    public HashIntoGroupImpl getHashIntoG1() throws UnsupportedOperationException {
        return new HashIntoCountingGroupImpl(this.getG1());
    }

    @Override
    public HashIntoGroupImpl getHashIntoG2() throws UnsupportedOperationException {
        return new HashIntoCountingGroupImpl(this.getG2());
    }

    @Override
    public HashIntoGroupImpl getHashIntoGT() throws UnsupportedOperationException {
        return new HashIntoCountingGroupImpl(this.getGT());
    }

    @Override
    public Integer getSecurityLevel() {
        return this.securityParameter;
    }

    @Override
    public BilinearGroup.Type getPairingType() {
        return this.pairingType;
    }
}

