/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.counting;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.counting.CountingBilinearMapImpl;
import org.cryptimeleon.math.structures.groups.counting.CountingGroup;
import org.cryptimeleon.math.structures.groups.counting.CountingGroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.groups.lazy.LazyBilinearMap;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroupElement;

public class CountingBilinearMap
implements BilinearMap {
    @Represented
    LazyBilinearMap totalBilMap;
    @Represented
    LazyBilinearMap expMultiExpBilMap;

    public CountingBilinearMap(LazyBilinearMap totalBilMap, LazyBilinearMap expMultiExpBilMap) {
        this.totalBilMap = totalBilMap;
        this.expMultiExpBilMap = expMultiExpBilMap;
    }

    public CountingBilinearMap(Representation repr) {
        ReprUtil.deserialize(this, repr);
    }

    @Override
    public Group getG1() {
        return new CountingGroup((LazyGroup)this.totalBilMap.getG1(), (LazyGroup)this.expMultiExpBilMap.getG1());
    }

    @Override
    public Group getG2() {
        return new CountingGroup((LazyGroup)this.totalBilMap.getG2(), (LazyGroup)this.expMultiExpBilMap.getG2());
    }

    @Override
    public Group getGT() {
        return new CountingGroup((LazyGroup)this.totalBilMap.getGT(), (LazyGroup)this.expMultiExpBilMap.getGT());
    }

    @Override
    public GroupElement apply(GroupElement g1, GroupElement g2, BigInteger exponent) {
        CountingGroupElement g1Cast = (CountingGroupElement)g1;
        CountingGroupElement g2Cast = (CountingGroupElement)g2;
        LazyGroupElement g1Result = (LazyGroupElement)this.totalBilMap.apply((GroupElement)g1Cast.elemTotal, (GroupElement)g2Cast.elemTotal, exponent);
        LazyGroupElement g2Result = (LazyGroupElement)this.expMultiExpBilMap.apply((GroupElement)g1Cast.elemExpMultiExp, (GroupElement)g2Cast.elemExpMultiExp, exponent);
        return new CountingGroupElement((CountingGroup)this.getGT(), g1Result, g2Result);
    }

    @Override
    public GroupElement apply(GroupElement g1, GroupElement g2) {
        CountingGroupElement g1Cast = (CountingGroupElement)g1;
        CountingGroupElement g2Cast = (CountingGroupElement)g2;
        LazyGroupElement g1Result = (LazyGroupElement)this.totalBilMap.apply(g1Cast.elemTotal, g2Cast.elemTotal);
        LazyGroupElement g2Result = (LazyGroupElement)this.expMultiExpBilMap.apply(g1Cast.elemExpMultiExp, g2Cast.elemExpMultiExp);
        return new CountingGroupElement((CountingGroup)this.getGT(), g1Result, g2Result);
    }

    @Override
    public boolean isSymmetric() {
        return this.totalBilMap.isSymmetric() && this.expMultiExpBilMap.isSymmetric();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CountingBilinearMap that = (CountingBilinearMap)other;
        return Objects.equals(this.totalBilMap, that.totalBilMap) && Objects.equals(this.expMultiExpBilMap, that.expMultiExpBilMap);
    }

    public int hashCode() {
        return Objects.hash(this.totalBilMap, this.expMultiExpBilMap);
    }

    public long getNumPairings() {
        return ((CountingBilinearMapImpl)this.totalBilMap.getImpl()).getNumPairings();
    }

    public void resetNumPairings() {
        ((CountingBilinearMapImpl)this.totalBilMap.getImpl()).resetNumPairings();
        ((CountingBilinearMapImpl)this.expMultiExpBilMap.getImpl()).resetNumPairings();
    }

    public String toString() {
        if (this.isSymmetric()) {
            return "Symmetric CountingBilinearMap(" + this.totalBilMap + ";" + this.expMultiExpBilMap + ")";
        }
        return "Asymmetric CountingBilinearMap(" + this.totalBilMap + ";" + this.expMultiExpBilMap + ")";
    }

    public String formatCounterData() {
        return "---------- Operation data for " + this.toString() + "----------\n" + ((CountingGroup)this.getG1()).formatCounterData() + (this.isSymmetric() ? "" : ((CountingGroup)this.getG2()).formatCounterData()) + ((CountingGroup)this.getGT()).formatCounterData() + "------- Number of pairings: " + this.getNumPairings() + " -------";
    }
}

