/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.counting;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.counting.CountingGroupElementImpl;
import org.cryptimeleon.math.structures.groups.counting.CountingGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMapImpl;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class CountingBilinearMapImpl
implements BilinearMapImpl {
    protected CountingGroupImpl g1;
    protected CountingGroupImpl g2;
    protected CountingGroupImpl gt;
    protected Zn zn;
    protected BigInteger size;
    protected BilinearGroup.Type pairingType;
    protected long numPairings;

    public CountingBilinearMapImpl(BilinearGroup.Type type, BigInteger groupSize, boolean enableExpCounting, boolean enableMultiExpCounting) {
        this.size = groupSize;
        this.zn = new Zn(groupSize);
        this.pairingType = type;
        this.g1 = new CountingGroupImpl("G1", groupSize, enableExpCounting, enableMultiExpCounting);
        this.g2 = type == BilinearGroup.Type.TYPE_1 ? this.g1 : new CountingGroupImpl("G2", groupSize, enableExpCounting, enableMultiExpCounting);
        this.gt = new CountingGroupImpl("GT", groupSize, enableExpCounting, enableMultiExpCounting);
        this.numPairings = 0L;
    }

    @Override
    public GroupElementImpl apply(GroupElementImpl g1, GroupElementImpl g2, BigInteger exponent) {
        return this.apply(g1.pow(exponent), g2);
    }

    @Override
    public GroupElementImpl apply(GroupElementImpl g1, GroupElementImpl g2) {
        if (!(g1 instanceof CountingGroupElementImpl) || !((CountingGroupElementImpl)g1).group.equals(this.g1)) {
            throw new IllegalArgumentException("first pairing argument is not in " + this.g1.name + ". It's in " + (!(g1 instanceof CountingGroupElementImpl) ? g1.getStructure() : (g1 == null ? null : ((CountingGroupElementImpl)g1).group.name)));
        }
        if (!(g2 instanceof CountingGroupElementImpl) || !((CountingGroupElementImpl)g2).group.equals(this.g2)) {
            throw new IllegalArgumentException("first pairing argument is not in " + this.g2.name + ". It's in " + (!(g2 instanceof CountingGroupElementImpl) ? g2.getStructure() : (g2 == null ? null : ((CountingGroupElementImpl)g2).group.name)));
        }
        CountingGroupElementImpl result = this.gt.wrap(((CountingGroupElementImpl)g1).elem.mul(((CountingGroupElementImpl)g2).elem));
        this.incrementNumPairings();
        return result;
    }

    public String toString() {
        return "DebugPairing";
    }

    @Override
    public boolean isSymmetric() {
        return this.pairingType == BilinearGroup.Type.TYPE_1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountingBilinearMapImpl that = (CountingBilinearMapImpl)o;
        return this.pairingType == that.pairingType && Objects.equals(this.size, that.size);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.size, this.pairingType});
    }

    public long getNumPairings() {
        return this.numPairings;
    }

    public void resetNumPairings() {
        this.numPairings = 0L;
    }

    protected void incrementNumPairings() {
        ++this.numPairings;
    }
}

