/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.counting;

import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.counting.CountingGroupElement;
import org.cryptimeleon.math.structures.groups.counting.CountingGroupImpl;
import org.cryptimeleon.math.structures.groups.lazy.ConstLazyGroupElement;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroupElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class CountingGroup
implements Group {
    @Represented
    LazyGroup groupTotal;
    @Represented
    LazyGroup groupExpMultiExp;

    public CountingGroup(String name, BigInteger n) {
        this.groupTotal = new LazyGroup(new CountingGroupImpl(name, n, false, false));
        this.groupExpMultiExp = new LazyGroup(new CountingGroupImpl(name, n, true, true));
    }

    public CountingGroup(String name, long n) {
        this(name, BigInteger.valueOf(n));
    }

    public CountingGroup(LazyGroup groupTotal, LazyGroup groupExpMultiExp) {
        this.groupTotal = groupTotal;
        this.groupExpMultiExp = groupExpMultiExp;
    }

    public CountingGroup(Representation repr) {
        new ReprUtil(this).deserialize(repr);
    }

    @Override
    public GroupElement getNeutralElement() {
        return new CountingGroupElement(this, (LazyGroupElement)this.groupTotal.getNeutralElement(), (LazyGroupElement)this.groupExpMultiExp.getNeutralElement());
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return this.groupTotal.size();
    }

    @Override
    public Zn getZn() {
        return this.groupTotal.getZn();
    }

    @Override
    public GroupElement getUniformlyRandomElement() throws UnsupportedOperationException {
        return new CountingGroupElement(this, (LazyGroupElement)this.groupTotal.getUniformlyRandomElement(), (LazyGroupElement)this.groupExpMultiExp.getUniformlyRandomElement());
    }

    @Override
    public GroupElement restoreElement(Representation repr) {
        return new CountingGroupElement(this, repr);
    }

    public CountingGroupElement wrap(Zn.ZnElement elem) {
        return new CountingGroupElement(this, new ConstLazyGroupElement(this.groupTotal, ((CountingGroupImpl)this.groupTotal.getImpl()).wrap(elem)), new ConstLazyGroupElement(this.groupExpMultiExp, ((CountingGroupImpl)this.groupExpMultiExp.getImpl()).wrap(elem)));
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        Optional<Integer> totalLength = this.groupTotal.getUniqueByteLength();
        Optional<Integer> expMultiExpLength = this.groupExpMultiExp.getUniqueByteLength();
        if (!totalLength.isPresent() || !expMultiExpLength.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(totalLength.get() + expMultiExpLength.get());
    }

    @Override
    public boolean isCommutative() {
        return this.groupTotal.isCommutative();
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    public long getNumSquaringsTotal() {
        return ((CountingGroupImpl)this.groupTotal.getImpl()).getNumSquarings();
    }

    public long getNumInversionsTotal() {
        return ((CountingGroupImpl)this.groupTotal.getImpl()).getNumInversions();
    }

    public long getNumOpsTotal() {
        return ((CountingGroupImpl)this.groupTotal.getImpl()).getNumOps();
    }

    public long getNumSquaringsNoExpMultiExp() {
        return ((CountingGroupImpl)this.groupExpMultiExp.getImpl()).getNumSquarings();
    }

    public long getNumInversionsNoExpMultiExp() {
        return ((CountingGroupImpl)this.groupExpMultiExp.getImpl()).getNumInversions();
    }

    public long getNumOpsNoExpMultiExp() {
        return ((CountingGroupImpl)this.groupExpMultiExp.getImpl()).getNumOps();
    }

    public long getNumExps() {
        return ((CountingGroupImpl)this.groupExpMultiExp.getImpl()).getNumExps();
    }

    public List<Integer> getMultiExpTermNumbers() {
        return ((CountingGroupImpl)this.groupExpMultiExp.getImpl()).getMultiExpTermNumbers();
    }

    public long getNumRetrievedRepresentations() {
        return ((CountingGroupImpl)this.groupTotal.getImpl()).getNumRetrievedRepresentations();
    }

    public void resetCounters() {
        ((CountingGroupImpl)this.groupTotal.getImpl()).resetCounters();
        ((CountingGroupImpl)this.groupExpMultiExp.getImpl()).resetCounters();
    }

    public String formatCounterData() {
        return "------- Operation data for " + this.toString() + " -------\n----- Total group operation data: -----\n    Number of Group Operations: " + this.getNumOpsTotal() + "\n    Number of Group Inversions: " + this.getNumInversionsTotal() + "\n    Number of Group Squarings: " + this.getNumSquaringsTotal() + "\n----- Group operation data without operations done in (multi-)exp algorithms: -----\n    Number of Group Operations: " + this.getNumOpsNoExpMultiExp() + "\n    Number of Group Inversions: " + this.getNumInversionsNoExpMultiExp() + "\n    Number of Group Squarings: " + this.getNumSquaringsNoExpMultiExp() + "\n----- Other data: -----\n    Number of exponentiations: " + this.getNumExps() + "\n    Number of terms in each multi-exponentiation: " + this.getMultiExpTermNumbers() + "\n    Number of retrieved representations (via getRepresentation()): " + this.getNumRetrievedRepresentations() + "\n";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountingGroup other = (CountingGroup)o;
        return Objects.equals(this.groupTotal, other.groupTotal) && Objects.equals(this.groupExpMultiExp, other.groupExpMultiExp);
    }

    public int hashCode() {
        return Objects.hash(this.groupTotal, this.groupExpMultiExp);
    }

    public String toString() {
        return "CountingGroup(" + this.groupTotal + ";" + this.groupExpMultiExp + ")";
    }
}

