/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.counting;

import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.GroupImpl;
import org.cryptimeleon.math.structures.groups.counting.CountingGroupElementImpl;
import org.cryptimeleon.math.structures.groups.exp.MultiExpTerm;
import org.cryptimeleon.math.structures.groups.exp.Multiexponentiation;
import org.cryptimeleon.math.structures.groups.exp.SmallExponentPrecomputation;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class CountingGroupImpl
implements GroupImpl {
    @Represented
    protected String name;
    @Represented
    protected Zn zn;
    @Represented
    protected Boolean enableExpCounting;
    @Represented
    protected Boolean enableMultiExpCounting;
    protected long numInversions;
    protected long numOps;
    protected long numSquarings;
    protected long numExps;
    protected long numRetrievedRepresentations;
    protected List<Integer> multiExpTermNumbers;

    public CountingGroupImpl(String name, BigInteger n) {
        this(name, n, false, false);
    }

    public CountingGroupImpl(String name, BigInteger n, boolean enableExpCounting, boolean enableMultiExpCounting) {
        this.zn = new Zn(n);
        this.name = name;
        this.enableExpCounting = enableExpCounting;
        this.enableMultiExpCounting = enableMultiExpCounting;
        this.numInversions = 0L;
        this.numOps = 0L;
        this.numSquarings = 0L;
        this.numExps = 0L;
        this.multiExpTermNumbers = new LinkedList<Integer>();
        this.numRetrievedRepresentations = 0L;
    }

    public CountingGroupImpl(Representation repr) {
        new ReprUtil(this).deserialize(repr);
        this.numInversions = 0L;
        this.numOps = 0L;
        this.numSquarings = 0L;
        this.numExps = 0L;
        this.multiExpTermNumbers = new LinkedList<Integer>();
        this.numRetrievedRepresentations = 0L;
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    @Override
    public GroupElementImpl getNeutralElement() {
        return this.wrap(this.zn.getZeroElement());
    }

    @Override
    public GroupElementImpl getUniformlyRandomElement() throws UnsupportedOperationException {
        return this.wrap(this.zn.getUniformlyRandomElement());
    }

    @Override
    public GroupElementImpl getUniformlyRandomNonNeutral() throws UnsupportedOperationException {
        return this.wrap(this.zn.getUniformlyRandomNonzeroElement());
    }

    @Override
    public GroupElementImpl restoreElement(Representation repr) {
        return this.wrap(this.zn.restoreElement(repr));
    }

    @Override
    public GroupElementImpl getGenerator() throws UnsupportedOperationException {
        return this.wrap(this.zn.getOneElement());
    }

    @Override
    public Optional<Integer> getUniqueByteLength() {
        return this.zn.getUniqueByteLength();
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CountingGroupImpl that = (CountingGroupImpl)other;
        return Objects.equals(this.name, that.name) && Objects.equals(this.zn, that.zn) && Objects.equals(this.enableExpCounting, that.enableExpCounting) && Objects.equals(this.enableMultiExpCounting, that.enableMultiExpCounting);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean isCommutative() {
        return true;
    }

    @Override
    public BigInteger size() throws UnsupportedOperationException {
        return this.zn.size();
    }

    @Override
    public boolean hasPrimeSize() throws UnsupportedOperationException {
        return this.zn.hasPrimeSize();
    }

    @Override
    public boolean implementsOwnExp() {
        return this.enableExpCounting;
    }

    @Override
    public GroupElementImpl exp(GroupElementImpl base, BigInteger exponent, SmallExponentPrecomputation precomputation) {
        return base.pow(exponent);
    }

    @Override
    public boolean implementsOwnMultiExp() {
        return this.enableMultiExpCounting;
    }

    @Override
    public GroupElementImpl multiexp(Multiexponentiation mexp) {
        CountingGroupElementImpl result = (CountingGroupElementImpl)mexp.getConstantFactor().orElse(this.getNeutralElement());
        for (MultiExpTerm term : mexp.getTerms()) {
            result = (CountingGroupElementImpl)result.op(((CountingGroupElementImpl)term.getBase()).pow(term.getExponent(), false), false);
        }
        this.addMultiExpBaseNumber(mexp.getTerms().size());
        return result;
    }

    public CountingGroupElementImpl wrap(Zn.ZnElement elem) {
        return new CountingGroupElementImpl(this, elem);
    }

    @Override
    public double estimateCostInvPerOp() {
        return 1.6;
    }

    protected void incrementNumOps() {
        ++this.numOps;
    }

    protected void incrementNumInversions() {
        ++this.numInversions;
    }

    protected void incrementNumSquarings() {
        ++this.numSquarings;
    }

    protected void incrementNumExps() {
        ++this.numExps;
    }

    protected void addMultiExpBaseNumber(int numTerms) {
        if (numTerms > 1) {
            this.multiExpTermNumbers.add(numTerms);
        }
    }

    protected void incrementNumRetrievedRepresentations() {
        ++this.numRetrievedRepresentations;
    }

    public long getNumInversions() {
        return this.numInversions;
    }

    public long getNumOps() {
        return this.numOps;
    }

    public long getNumSquarings() {
        return this.numSquarings;
    }

    public long getNumExps() {
        return this.numExps;
    }

    public List<Integer> getMultiExpTermNumbers() {
        return this.multiExpTermNumbers;
    }

    public long getNumRetrievedRepresentations() {
        return this.numRetrievedRepresentations;
    }

    public void resetOpsCounter() {
        this.numOps = 0L;
    }

    public void resetInvsCounter() {
        this.numInversions = 0L;
    }

    public void resetSquaringsCounter() {
        this.numSquarings = 0L;
    }

    public void resetExpsCounter() {
        this.numExps = 0L;
    }

    public void resetMultiExpTermNumbers() {
        this.multiExpTermNumbers = new LinkedList<Integer>();
    }

    public void resetRetrievedRepresentationsCounter() {
        this.numRetrievedRepresentations = 0L;
    }

    public void resetCounters() {
        this.resetOpsCounter();
        this.resetInvsCounter();
        this.resetSquaringsCounter();
        this.resetExpsCounter();
        this.resetMultiExpTermNumbers();
        this.resetRetrievedRepresentationsCounter();
    }
}

