/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.counting;

import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.counting.CountingGroupElementImpl;
import org.cryptimeleon.math.structures.groups.counting.CountingGroupImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.GroupHomomorphismImpl;

public class CountingIsomorphismImpl
implements GroupHomomorphismImpl {
    @Represented
    private CountingGroupImpl src;
    @Represented
    private CountingGroupImpl target;

    public CountingIsomorphismImpl(CountingGroupImpl src, CountingGroupImpl target) {
        this.src = src;
        this.target = target;
    }

    public CountingIsomorphismImpl(Representation repr) {
        new ReprUtil(this).deserialize(repr);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    @Override
    public GroupElementImpl apply(GroupElementImpl groupElement) {
        if (!groupElement.getStructure().equals(this.src)) {
            throw new IllegalArgumentException("Tried to apply isomorphism on wrong group (argument was from " + groupElement.getStructure() + ")");
        }
        return new CountingGroupElementImpl(this.target, ((CountingGroupElementImpl)groupElement).elem);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountingIsomorphismImpl that = (CountingIsomorphismImpl)o;
        return Objects.equals(this.src, that.src) && Objects.equals(this.target, that.target);
    }

    public int hashCode() {
        return Objects.hash(this.src, this.target);
    }
}

