/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.counting;

import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.HashIntoGroup;
import org.cryptimeleon.math.structures.groups.counting.CountingGroup;
import org.cryptimeleon.math.structures.groups.counting.CountingGroupElement;
import org.cryptimeleon.math.structures.groups.lazy.HashIntoLazyGroup;

public class HashIntoCountingGroup
implements HashIntoGroup {
    @Represented
    private HashIntoLazyGroup totalHashIntoGroup;
    @Represented
    private HashIntoLazyGroup expMultiExpHashIntoGroup;

    public HashIntoCountingGroup(HashIntoLazyGroup totalHashIntoStructure, HashIntoLazyGroup expMultiExpHashIntoStructure) {
        this.totalHashIntoGroup = totalHashIntoStructure;
        this.expMultiExpHashIntoGroup = expMultiExpHashIntoStructure;
    }

    public HashIntoCountingGroup(Representation repr) {
        new ReprUtil(this).deserialize(repr);
    }

    @Override
    public GroupElement hash(byte[] x) {
        return new CountingGroupElement(new CountingGroup(this.totalHashIntoGroup.getTarget(), this.expMultiExpHashIntoGroup.getTarget()), this.totalHashIntoGroup.hash(x), this.expMultiExpHashIntoGroup.hash(x));
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HashIntoCountingGroup that = (HashIntoCountingGroup)other;
        return Objects.equals(this.totalHashIntoGroup, that.totalHashIntoGroup) && Objects.equals(this.expMultiExpHashIntoGroup, that.expMultiExpHashIntoGroup);
    }

    public int hashCode() {
        return Objects.hash(this.totalHashIntoGroup, this.expMultiExpHashIntoGroup);
    }
}

