/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.counting;

import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.counting.CountingGroupImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;
import org.cryptimeleon.math.structures.rings.zn.HashIntoZn;

public class HashIntoCountingGroupImpl
implements HashIntoGroupImpl {
    protected CountingGroupImpl group;
    protected HashIntoZn hash;

    public HashIntoCountingGroupImpl(CountingGroupImpl group) {
        this.group = group;
        this.hash = new HashIntoZn(group.size());
    }

    public HashIntoCountingGroupImpl(Representation repr) {
        this(new CountingGroupImpl(repr));
    }

    @Override
    public Representation getRepresentation() {
        return this.group.getRepresentation();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashIntoCountingGroupImpl that = (HashIntoCountingGroupImpl)o;
        return Objects.equals(this.group, that.group);
    }

    public int hashCode() {
        return Objects.hash(this.group);
    }

    @Override
    public GroupElementImpl hashIntoGroupImpl(byte[] x) {
        return this.group.wrap(this.hash.hash(x));
    }
}

