/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic;

import java.math.BigInteger;
import java.util.function.BiFunction;
import org.cryptimeleon.math.expressions.group.GroupElementExpression;
import org.cryptimeleon.math.expressions.group.PairingExpr;
import org.cryptimeleon.math.structures.cartesian.Vector;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.cartesian.GroupElementVector;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public interface BilinearMap
extends BiFunction<GroupElement, GroupElement, GroupElement> {
    public Group getG1();

    public Group getG2();

    public Group getGT();

    public GroupElement apply(GroupElement var1, GroupElement var2, BigInteger var3);

    @Override
    default public GroupElement apply(GroupElement g1, GroupElement g2) {
        return this.apply(g1, g2, BigInteger.ONE);
    }

    default public GroupElement apply(GroupElement g1, GroupElement g2, Zn.ZnElement exponent) {
        return this.apply(g1, g2, exponent.getInteger());
    }

    @Override
    default public GroupElementVector apply(GroupElementVector lhs, GroupElementVector rhs) {
        return new GroupElementVector((Vector<? extends GroupElement>)lhs.zip(rhs, this));
    }

    default public GroupElement innerProduct(GroupElementVector lhs, GroupElementVector rhs) {
        return lhs.innerProduct(rhs, this);
    }

    default public PairingExpr applyExpr(GroupElementExpression g1elem, GroupElementExpression g2elem) {
        return new PairingExpr(this, g1elem, g2elem);
    }

    default public PairingExpr applyExpr(GroupElement g1elem, GroupElement g2elem) {
        return this.applyExpr((GroupElementExpression)g1elem.expr(), (GroupElementExpression)g2elem.expr());
    }

    default public PairingExpr applyExpr(GroupElement g1elem, GroupElementExpression g2elem) {
        return this.applyExpr((GroupElementExpression)g1elem.expr(), g2elem);
    }

    default public PairingExpr applyExpr(GroupElementExpression g1elem, GroupElement g2elem) {
        return this.applyExpr(g1elem, (GroupElementExpression)g2elem.expr());
    }

    public boolean isSymmetric();
}

