/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic;

import java.util.Objects;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.UniqueByteRepresentable;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.PairingTargetGroupImpl;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionFieldElement;

public abstract class PairingTargetGroupElementImpl
implements GroupElementImpl,
UniqueByteRepresentable {
    protected ExtensionFieldElement elem;
    protected PairingTargetGroupImpl group;

    public ExtensionFieldElement getElem() {
        return this.elem;
    }

    public PairingTargetGroupElementImpl(PairingTargetGroupImpl g, ExtensionFieldElement fe) {
        this.group = g;
        this.elem = fe;
    }

    @Override
    public Representation getRepresentation() {
        return this.elem.getRepresentation();
    }

    @Override
    public PairingTargetGroupImpl getStructure() {
        return this.group;
    }

    @Override
    public PairingTargetGroupElementImpl inv() {
        FieldElement[] coefficients = new FieldElement[this.getElem().getCoefficients().length];
        for (int i = 0; i < this.getElem().getCoefficients().length; ++i) {
            coefficients[i] = i % 2 == 0 ? this.getElem().getCoefficients()[i] : this.getElem().getCoefficients()[i].neg();
        }
        return this.getStructure().getElement(this.getStructure().getFieldOfDefinition().createElement(coefficients));
    }

    @Override
    public PairingTargetGroupElementImpl op(GroupElementImpl e) throws IllegalArgumentException {
        return this.getStructure().getElement(this.elem.mul(((PairingTargetGroupElementImpl)e).getElem()));
    }

    public String toString() {
        return this.elem.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PairingTargetGroupElementImpl that = (PairingTargetGroupElementImpl)o;
        return this.elem.equals(that.elem) && this.group.equals(that.group);
    }

    public int hashCode() {
        return Objects.hash(this.elem);
    }

    @Override
    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        accumulator = this.elem.updateAccumulator(accumulator);
        return accumulator;
    }
}

