/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular;

import java.math.BigInteger;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.elliptic.PairingSourceGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular.SupersingularSourceGroupElementImpl;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionField;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionFieldElement;
import org.cryptimeleon.math.structures.rings.helpers.FiniteFieldTools;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class SupersingularSourceGroupImpl
extends PairingSourceGroupImpl {
    public SupersingularSourceGroupImpl(BigInteger size, BigInteger cofactor, ExtensionField fieldOfDefinition) {
        super(size, cofactor, fieldOfDefinition.getElement(-3L), fieldOfDefinition.getZeroElement());
    }

    public SupersingularSourceGroupImpl(Representation r) {
        super(r);
    }

    @Override
    public SupersingularSourceGroupElementImpl getNeutralElement() {
        return new SupersingularSourceGroupElementImpl(this);
    }

    @Override
    public SupersingularSourceGroupElementImpl getElement(FieldElement x, FieldElement y) {
        return new SupersingularSourceGroupElementImpl(this, x, y);
    }

    protected SupersingularSourceGroupElementImpl mapToPoint(ExtensionFieldElement z) {
        ExtensionFieldElement x = z;
        if (!this.isShortForm() || !this.getA6().isZero()) {
            throw new UnsupportedOperationException("Mapping to point only implemented for curves of the form x^3+a4x=y^2");
        }
        ExtensionFieldElement y = x.mul(x).add(this.getA4()).mul(x);
        if (!FiniteFieldTools.isSquare(y)) {
            x = x.neg();
            y = y.neg();
            y = (ExtensionFieldElement)FiniteFieldTools.sqrt(y).neg();
        } else {
            y = (ExtensionFieldElement)FiniteFieldTools.sqrt(y);
        }
        return (SupersingularSourceGroupElementImpl)this.cofactorMultiplication(x, y);
    }

    @Override
    public SupersingularSourceGroupElementImpl getGenerator() {
        SupersingularSourceGroupElementImpl elem;
        if (this.generator != null) {
            return (SupersingularSourceGroupElementImpl)this.generator;
        }
        while ((elem = this.getUniformlyRandomElement()).equals(this.getNeutralElement())) {
        }
        return elem;
    }

    @Override
    public boolean hasPrimeSize() {
        return true;
    }

    @Override
    public SupersingularSourceGroupElementImpl getUniformlyRandomElement() throws UnsupportedOperationException {
        if (this.getSize().compareTo(this.getCofactor()) < 0 && this.generator != null) {
            return (SupersingularSourceGroupElementImpl)this.getGenerator().pow(new Zn(this.getSize()).getUniformlyRandomElement().getInteger());
        }
        return this.mapToPoint((ExtensionFieldElement)this.getFieldOfDefinition().getUniformlyRandomElement());
    }

    @Override
    public boolean isShortForm() {
        return true;
    }

    @Override
    public double estimateCostInvPerOp() {
        return 6500.0;
    }
}

