/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMapImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular.SupersingularSourceGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular.SupersingularSourceHash;
import org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular.SupersingularTargetGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type1.supersingular.SupersingularTatePairing;
import org.cryptimeleon.math.structures.groups.mappings.IdentityIsomorphism;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionField;
import org.cryptimeleon.math.structures.rings.helpers.FiniteFieldTools;

public class SupersingularTateGroupImpl
implements BilinearGroupImpl {
    @Represented
    private Integer securityParameter;
    protected final int[] securityLimits = new int[]{48, 56, 64, 80, 112, 128, 160, 192, 256};
    protected final int[] minimumFieldSize = new int[]{480, 640, 816, 1248, 2432, 3248, 5312, 7936, 15424};
    @Represented
    private SupersingularSourceGroupImpl g1;
    @Represented
    private SupersingularTargetGroupImpl gt;
    private SupersingularTatePairing pairing;
    @Represented
    private SupersingularSourceHash hashIntoG1;

    public SupersingularTateGroupImpl(int securityParameter) {
        if (securityParameter > this.securityLimits[this.securityLimits.length - 1]) {
            throw new IllegalArgumentException("Cannot accommodate a security parameter of " + securityParameter + ", please choose one of at most " + this.securityLimits[this.securityLimits.length - 1]);
        }
        this.securityParameter = securityParameter;
        int logExtFieldSize = 0;
        for (int i = 0; i < this.securityLimits.length; ++i) {
            if (securityParameter > this.securityLimits[i]) continue;
            logExtFieldSize = this.minimumFieldSize[i];
            break;
        }
        this.init(logExtFieldSize);
    }

    public SupersingularTateGroupImpl(Representation repr) {
        new ReprUtil(this).deserialize(repr);
        this.pairing = new SupersingularTatePairing(this.g1, this.gt);
    }

    @Override
    public GroupImpl getG1() {
        return this.g1;
    }

    @Override
    public GroupImpl getG2() {
        return this.getG1();
    }

    @Override
    public GroupImpl getGT() {
        return this.gt;
    }

    @Override
    public BilinearMapImpl getBilinearMap() {
        return this.pairing;
    }

    @Override
    public IdentityIsomorphism getHomomorphismG2toG1() throws UnsupportedOperationException {
        return new IdentityIsomorphism();
    }

    @Override
    public HashIntoGroupImpl getHashIntoG1() throws UnsupportedOperationException {
        return this.hashIntoG1;
    }

    @Override
    public HashIntoGroupImpl getHashIntoG2() throws UnsupportedOperationException {
        return this.getHashIntoG1();
    }

    @Override
    public HashIntoGroupImpl getHashIntoGT() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The hash function into the target group is not implemented yet!");
    }

    @Override
    public Integer getSecurityLevel() {
        return this.securityParameter;
    }

    @Override
    public BilinearGroup.Type getPairingType() {
        return BilinearGroup.Type.TYPE_1;
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupersingularTateGroupImpl that = (SupersingularTateGroupImpl)o;
        return this.g1.equals(that.g1) && this.gt.equals(that.gt) && this.pairing.equals(that.pairing) && this.hashIntoG1.equals(that.hashIntoG1);
    }

    public int hashCode() {
        return Objects.hash(this.g1);
    }

    protected void init(int logExtFieldSize) {
        BigInteger characteristic;
        BigInteger groupOrder = RandomGenerator.getRandomPrime(2 * this.securityParameter);
        BigInteger minCofactorSize = BigInteger.ONE.shiftLeft(logExtFieldSize / 2 - this.securityParameter * 2);
        BigInteger cofactor = minCofactorSize.shiftLeft(2);
        while (!(characteristic = groupOrder.multiply(cofactor = cofactor.add(BigInteger.ONE)).subtract(BigInteger.ONE)).isProbablePrime(100) || 3 != characteristic.mod(BigInteger.valueOf(4L)).intValue() || logExtFieldSize / 2 > characteristic.bitLength() || !groupOrder.gcd(cofactor).equals(BigInteger.ONE)) {
        }
        ExtensionField fieldOfDefinition = new ExtensionField(characteristic);
        SupersingularSourceGroupImpl sourceGroup = new SupersingularSourceGroupImpl(groupOrder, cofactor, fieldOfDefinition);
        sourceGroup.setGenerator(sourceGroup.getGenerator());
        FieldElement qnr = fieldOfDefinition.getElement(-1L);
        while (FiniteFieldTools.isSquare(qnr)) {
            qnr = qnr.add(fieldOfDefinition.getElement(-1L));
        }
        ExtensionField targetGroupField = new ExtensionField(qnr.neg(), 2);
        SupersingularTargetGroupImpl targetGroup = new SupersingularTargetGroupImpl(targetGroupField, groupOrder);
        this.g1 = sourceGroup;
        this.gt = targetGroup;
        this.pairing = new SupersingularTatePairing(sourceGroup, targetGroup);
        this.hashIntoG1 = new SupersingularSourceHash(sourceGroup);
    }
}

