/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic.type3.bn;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.hash.impl.AbstractSHAHashFunction;
import org.cryptimeleon.math.hash.impl.SHA256HashFunction;
import org.cryptimeleon.math.hash.impl.SHA512HashFunction;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMapImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigGroup1ElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigGroup1Impl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigGroup2ElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigGroup2Impl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigParameterSpec;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigPointEncoding;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigTargetGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigTatePairing;
import org.cryptimeleon.math.structures.groups.mappings.impl.GroupHomomorphismImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionField;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionFieldElement;

public class BarretoNaehrigBilinearGroupImpl
implements BilinearGroupImpl {
    @Represented
    private Integer securityParameter;
    protected final int[] securityLimits = new int[]{100, 128};
    protected final int[] minimumGroupBitSize = new int[]{256, 461};
    @Represented
    private BigInteger u;
    @Represented
    private BarretoNaehrigGroup1Impl g1impl;
    @Represented
    private BarretoNaehrigGroup2Impl g2impl;
    @Represented
    private BarretoNaehrigTargetGroupImpl gtimpl;
    @Represented
    private BarretoNaehrigPointEncoding hashIntoG1impl;
    @Represented
    private BarretoNaehrigPointEncoding hashIntoG2impl;
    private BarretoNaehrigTatePairing bilinearMapImpl;

    public BarretoNaehrigBilinearGroupImpl(int securityParameter) {
        if (securityParameter > this.securityLimits[this.securityLimits.length - 1]) {
            throw new IllegalArgumentException("Cannot accommodate a security parameter of " + securityParameter + ", please choose one of at most " + this.securityLimits[this.securityLimits.length - 1]);
        }
        this.securityParameter = securityParameter;
        int groupBitSize = 0;
        for (int i = 0; i < this.securityLimits.length; ++i) {
            if (securityParameter > this.securityLimits[i]) continue;
            groupBitSize = this.minimumGroupBitSize[i];
            break;
        }
        this.init(groupBitSize);
    }

    public BarretoNaehrigBilinearGroupImpl(String spec) {
        this(BarretoNaehrigParameterSpec.getParameters(spec));
    }

    public BarretoNaehrigBilinearGroupImpl(BarretoNaehrigParameterSpec spec) {
        AbstractSHAHashFunction hash;
        this.u = spec.u;
        BigInteger n = spec.size;
        BigInteger p = spec.characteristic;
        ExtensionField baseField = new ExtensionField(p);
        baseField.generatePrimitiveCubeRoot();
        ExtensionFieldElement b = baseField.createElement(spec.b);
        this.g1impl = new BarretoNaehrigGroup1Impl(n, BigInteger.ONE, b);
        ExtensionFieldElement alpha = baseField.createElement(spec.alpha);
        ExtensionField F2 = new ExtensionField(alpha, 2);
        F2.generatePrimitiveCubeRoot();
        ExtensionFieldElement beta = F2.createElement(baseField.createElement(spec.beta0), baseField.createElement(spec.beta1));
        BigInteger t = p.add(BigInteger.ONE).subtract(n);
        this.g2impl = new BarretoNaehrigGroup2Impl(n, t, (ExtensionFieldElement)F2.createElement(b).div(beta.neg()));
        BarretoNaehrigGroup1ElementImpl P1 = this.g1impl.getElement(baseField.createElement(spec.x1), baseField.createElement(spec.y1));
        BarretoNaehrigGroup2ElementImpl P2 = this.g2impl.getElement(F2.createElement(baseField.createElement(spec.x20), baseField.createElement(spec.x21)), F2.createElement(baseField.createElement(spec.y20), baseField.createElement(spec.y21)));
        this.g1impl.setGenerator(P1);
        this.g2impl.setGenerator(P2);
        this.gtimpl = new BarretoNaehrigTargetGroupImpl(beta, n);
        switch (spec.hash) {
            case "SHA-256": {
                hash = new SHA256HashFunction();
                break;
            }
            case "SHA-512": {
                hash = new SHA512HashFunction();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown hash function " + spec.hash);
            }
        }
        this.hashIntoG1impl = new BarretoNaehrigPointEncoding(hash, this.g1impl);
        this.hashIntoG2impl = new BarretoNaehrigPointEncoding(hash, this.g2impl);
        if (!"Tate".equals(spec.pairing)) {
            throw new IllegalArgumentException("Pairing of type " + spec.pairing + " not supported.");
        }
        this.bilinearMapImpl = new BarretoNaehrigTatePairing(this.g1impl, this.g2impl, this.gtimpl, this.u);
    }

    public BarretoNaehrigBilinearGroupImpl(Representation representation) {
        new ReprUtil(this).deserialize(representation);
        this.bilinearMapImpl = new BarretoNaehrigTatePairing(this.g1impl, this.g2impl, this.gtimpl, this.u);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    @Override
    public GroupImpl getG1() {
        return this.g1impl;
    }

    @Override
    public GroupImpl getG2() {
        return this.g2impl;
    }

    @Override
    public GroupImpl getGT() {
        return this.gtimpl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BarretoNaehrigBilinearGroupImpl that = (BarretoNaehrigBilinearGroupImpl)o;
        return this.g1impl.equals(that.g1impl) && this.g2impl.equals(that.g2impl) && this.gtimpl.equals(that.gtimpl) && this.bilinearMapImpl.equals(that.bilinearMapImpl) && this.hashIntoG1impl.equals(that.hashIntoG1impl) && this.hashIntoG2impl.equals(that.hashIntoG2impl);
    }

    public int hashCode() {
        return Objects.hash(this.g1impl);
    }

    @Override
    public BilinearMapImpl getBilinearMap() {
        return this.bilinearMapImpl;
    }

    @Override
    public HashIntoGroupImpl getHashIntoG1() throws UnsupportedOperationException {
        return this.hashIntoG1impl;
    }

    @Override
    public HashIntoGroupImpl getHashIntoG2() {
        return this.hashIntoG2impl;
    }

    @Override
    public HashIntoGroupImpl getHashIntoGT() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer getSecurityLevel() {
        return this.securityParameter;
    }

    @Override
    public BilinearGroup.Type getPairingType() {
        return BilinearGroup.Type.TYPE_3;
    }

    @Override
    public GroupHomomorphismImpl getHomomorphismG2toG1() {
        throw new UnsupportedOperationException("Map G2->G1 not available for BN Type 3 Pairings.");
    }

    public String toString() {
        return "BarretoNaehrigBilinearGroupImpl{g1impl=" + this.g1impl + ", g2impl=" + this.g2impl + ", gtimpl=" + this.gtimpl + ", bilinearMapImpl=" + this.bilinearMapImpl + ", hashIntoG1impl=" + this.hashIntoG1impl + ", hashIntoG2impl=" + this.hashIntoG2impl + '}';
    }

    /*
     * Unable to fully structure code
     */
    protected void init(int groupBitSize) {
        this.u = BigInteger.ONE.shiftLeft(groupBitSize / 4 + 1);
        this.u = this.u.add(BigInteger.ONE).subtract(this.u.mod(BigInteger.valueOf(6L)));
        while (true) {
            t = BarretoNaehrigBilinearGroupImpl.t(this.u);
            q = BarretoNaehrigBilinearGroupImpl.p(this.u);
            n = BarretoNaehrigBilinearGroupImpl.groupOrder(q, t);
            if (q.isProbablePrime(10) && n.isProbablePrime(10)) break;
            this.u = this.u.add(BigInteger.valueOf(6L));
        }
        if (q.mod(BigInteger.valueOf(4L)).intValue() != 3) {
            throw new IllegalArgumentException();
        }
        if (q.mod(BigInteger.valueOf(9L)).intValue() != 4) {
            throw new IllegalArgumentException();
        }
        baseField = new ExtensionField(q);
        y = baseField.getOneElement();
        while (true) {
            if ((b = baseField.getUniformlyRandomElement()).pow(baseField.sizeUnitGroup().divide(BigInteger.valueOf(2L))).isOne() || b.pow(baseField.sizeUnitGroup().divide(BigInteger.valueOf(3L))).isOne()) {
                continue;
            }
            g1 = new BarretoNaehrigGroup1Impl(n, BigInteger.ONE, b);
            try {
                P1 = (BarretoNaehrigGroup1ElementImpl)g1.mapToSubgroup(y, 0);
                g1.setGenerator(P1);
            }
            catch (IllegalArgumentException var13_10) {
                continue;
            }
            if (P1.pow(g1.size()).isNeutralElement()) break;
        }
        extField1 = new ExtensionField(baseField.getOneElement(), 2);
        v = extField1.createElement(new FieldElement[]{baseField.getZeroElement(), baseField.getOneElement()});
        block4: while (true) {
            if ((v = v.add(extField1.getOneElement())).pow(extField1.sizeUnitGroup().divide(BigInteger.valueOf(2L))).isOne() || v.pow(extField1.sizeUnitGroup().divide(BigInteger.valueOf(3L))).isOne()) {
                continue;
            }
            bInExt = extField1.createElement(new FieldElement[]{b});
            var16_16 = new int[]{1};
            var17_17 = var16_16.length;
            var18_18 = 0;
            while (true) {
                if (var18_18 < var17_17) ** break;
                continue block4;
                i = var16_16[var18_18];
                v = (ExtensionFieldElement)v.pow(BigInteger.valueOf(i));
                bTwist = (ExtensionFieldElement)bInExt.div(v).neg();
                g2 = new BarretoNaehrigGroup2Impl(n, t, bTwist);
                while ((P2 = (BarretoNaehrigGroup2ElementImpl)g2.getUniformlyRandomElement()).isNeutralElement()) {
                }
                g2.setGenerator(P2);
                if (P2.pow(g2.size()).isNeutralElement()) {
                    gT = new BarretoNaehrigTargetGroupImpl(v, n);
                    this.init(P1, P2, gT, this.u);
                    return;
                }
                ++var18_18;
            }
            break;
        }
    }

    private void init(BarretoNaehrigGroup1ElementImpl P1, BarretoNaehrigGroup2ElementImpl P2, BarretoNaehrigTargetGroupImpl gT, BigInteger u) {
        this.g1impl = (BarretoNaehrigGroup1Impl)P1.getStructure();
        this.g2impl = (BarretoNaehrigGroup2Impl)P2.getStructure();
        this.gtimpl = gT;
        this.bilinearMapImpl = new BarretoNaehrigTatePairing(this.g1impl, this.g2impl, gT, u);
        this.hashIntoG1impl = new BarretoNaehrigPointEncoding(this.g1impl);
        this.hashIntoG2impl = new BarretoNaehrigPointEncoding(this.g2impl);
    }

    private static BigInteger p(BigInteger u) {
        return BigInteger.valueOf(36L).multiply(u.pow(4).add(u.pow(3))).add(BigInteger.valueOf(24L).multiply(u.pow(2))).add(BigInteger.valueOf(6L).multiply(u)).add(BigInteger.ONE);
    }

    private static BigInteger t(BigInteger u) {
        return BigInteger.valueOf(6L).multiply(u.pow(2)).add(BigInteger.ONE);
    }

    private static BigInteger groupOrder(BigInteger q, BigInteger t) {
        return q.add(BigInteger.ONE).subtract(t);
    }
}

