/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic.type3.bn;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.hash.HashFunction;
import org.cryptimeleon.math.hash.impl.ByteArrayAccumulator;
import org.cryptimeleon.math.hash.impl.SHA256HashFunction;
import org.cryptimeleon.math.hash.impl.SHA512HashFunction;
import org.cryptimeleon.math.hash.impl.VariableOutputLengthHashFunction;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigSourceGroupElementImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigSourceGroupImpl;
import org.cryptimeleon.math.structures.groups.mappings.impl.HashIntoGroupImpl;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionField;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionFieldElement;

public class BarretoNaehrigPointEncoding
implements HashIntoGroupImpl {
    @Represented
    private BarretoNaehrigSourceGroupImpl codomain;
    @Represented
    private HashFunction hashFunction;

    protected void check() {
        BigInteger groupSize;
        BigInteger digestSize = BigInteger.ONE.shiftLeft(this.hashFunction.getOutputLength() * 8);
        if (digestSize.compareTo(groupSize = this.codomain.getFieldOfDefinition().size()) >= 0) {
            throw new IllegalArgumentException("Codomain to small for injective hashing hash of length " + this.hashFunction.getOutputLength() * 8 + " bit.");
        }
    }

    public BarretoNaehrigPointEncoding(HashFunction hashFunction, BarretoNaehrigSourceGroupImpl codomain) {
        this.codomain = codomain;
        this.hashFunction = hashFunction;
        this.check();
    }

    public BarretoNaehrigPointEncoding(BarretoNaehrigSourceGroupImpl codomain) {
        BigInteger s = codomain.size();
        this.codomain = codomain;
        this.hashFunction = s.compareTo(BigInteger.ONE.shiftLeft(512)) > 0 ? new SHA512HashFunction() : (s.compareTo(BigInteger.ONE.shiftLeft(256)) > 0 ? new SHA256HashFunction() : new VariableOutputLengthHashFunction((codomain.getFieldOfDefinition().size().bitLength() - 1) / 8));
        this.check();
    }

    public BarretoNaehrigPointEncoding(Representation r) {
        new ReprUtil(this).deserialize(r);
        this.check();
    }

    public HashFunction getHashFunction() {
        return this.hashFunction;
    }

    @Override
    public BarretoNaehrigSourceGroupElementImpl hashIntoGroupImpl(byte[] x) {
        byte i = 0;
        while (true) {
            ByteArrayAccumulator accumulator = new ByteArrayAccumulator();
            ((ByteAccumulator)accumulator).append(x);
            ((ByteAccumulator)accumulator).append(new byte[]{i});
            byte[] h = this.hashFunction.hash(((ByteAccumulator)accumulator).extractBytes());
            BigInteger b = new BigInteger(h);
            ExtensionFieldElement y = ((ExtensionField)this.codomain.getFieldOfDefinition()).createElement(b);
            try {
                return (BarretoNaehrigSourceGroupElementImpl)this.codomain.mapToSubgroup(y, 0);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ((i = (byte)(i + 1)) != 0) continue;
                throw new InternalError("Was not able to hash " + Arrays.toString(x) + ".\n This should not happen with reasonable probability.");
            }
            break;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BarretoNaehrigPointEncoding that = (BarretoNaehrigPointEncoding)o;
        return this.codomain.equals(that.codomain) && this.hashFunction.equals(that.hashFunction);
    }

    public int hashCode() {
        return Objects.hash(this.codomain, this.hashFunction);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }
}

