/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.elliptic.type3.bn;

import java.math.BigInteger;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.groups.elliptic.PairingSourceGroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.PairingSourceGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.type3.bn.BarretoNaehrigSourceGroupElementImpl;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionField;
import org.cryptimeleon.math.structures.rings.extfield.ExtensionFieldElement;

public abstract class BarretoNaehrigSourceGroupImpl
extends PairingSourceGroupImpl {
    public BarretoNaehrigSourceGroupImpl(BigInteger size, BigInteger cofactor, ExtensionFieldElement a6) {
        super(size, cofactor, a6.getStructure().getZeroElement(), a6);
    }

    public BarretoNaehrigSourceGroupImpl(Representation r) {
        super(r);
    }

    protected PairingSourceGroupElement getUniformlyRandomElementOblivious() throws UnsupportedOperationException {
        while (true) {
            FieldElement y = this.getFieldOfDefinition().getUniformlyRandomElement();
            int sel = RandomGenerator.getRandomNumber(BigInteger.valueOf(3L)).intValue();
            try {
                return this.mapToSubgroup(y, sel);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            break;
        }
    }

    public PairingSourceGroupElement mapToSubgroup(FieldElement y, int sel) {
        if (!this.size().gcd(this.getCofactor()).equals(BigInteger.ONE)) {
            throw new IllegalArgumentException("Require cofactor coprime to order of subgroup.");
        }
        return this.cofactorMultiplication(this.decompressX(y, sel), y);
    }

    public PairingSourceGroupElement mapToPoint(FieldElement y, int sel) {
        return this.getElement(this.decompressX(y, sel), y);
    }

    public FieldElement decompressX(FieldElement y, int sel) {
        BigInteger e;
        FieldElement tmp = y.pow(BigInteger.valueOf(2L));
        tmp = tmp.sub(this.getA6());
        switch (this.getFieldOfDefinition().size().mod(BigInteger.valueOf(9L)).intValue()) {
            case 4: {
                e = this.getFieldOfDefinition().size().multiply(BigInteger.valueOf(2L)).add(BigInteger.ONE);
                break;
            }
            case 7: {
                e = this.getFieldOfDefinition().size().add(BigInteger.valueOf(2L));
                break;
            }
            default: {
                throw new UnsupportedOperationException("The function mapToPoint is only implemented for fields with order mod 9 in {4,7}");
            }
        }
        e = e.divide(BigInteger.valueOf(9L));
        FieldElement x = tmp.pow(e);
        if (!x.pow(BigInteger.valueOf(3L)).equals(tmp)) {
            throw new IllegalArgumentException("Argument " + y + "is not a cube in " + x.getStructure());
        }
        x = x.mul(((ExtensionField)this.getFieldOfDefinition()).getCubeRoot().pow(BigInteger.valueOf(sel)));
        return x;
    }

    @Override
    public BarretoNaehrigSourceGroupElementImpl getUniformlyRandomElement() throws UnsupportedOperationException {
        return (BarretoNaehrigSourceGroupElementImpl)this.getUniformlyRandomElementOblivious();
    }

    public String toString() {
        String s = "";
        s = s + "Subgroup of F-rational points on E:x^3+b with b=" + this.getA6().toString();
        return s;
    }

    @Override
    public boolean isShortForm() {
        return true;
    }

    @Override
    public boolean hasPrimeSize() throws UnsupportedOperationException {
        return true;
    }

    protected PairingSourceGroupElement superGetUniformlyRandomElement() {
        return super.getUniformlyRandomElement();
    }
}

