/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.lazy;

import java.math.BigInteger;
import java.util.Objects;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMapImpl;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.PairingResultLazyGroupElement;

public class LazyBilinearMap
implements BilinearMap {
    protected BilinearMapImpl impl;
    protected LazyGroup g1;
    protected LazyGroup g2;
    protected LazyGroup gt;

    public LazyBilinearMap(LazyGroup g1, LazyGroup g2, LazyGroup gt, BilinearMapImpl impl) {
        this.impl = impl;
        this.g1 = g1;
        this.g2 = g2;
        this.gt = gt;
    }

    @Override
    public Group getG1() {
        return this.g1;
    }

    @Override
    public Group getG2() {
        return this.g2;
    }

    @Override
    public Group getGT() {
        return this.gt;
    }

    @Override
    public GroupElement apply(GroupElement g1, GroupElement g2, BigInteger exponent) {
        return new PairingResultLazyGroupElement(this.gt, this, g1, g2).pow(exponent);
    }

    @Override
    public GroupElement apply(GroupElement g1, GroupElement g2) {
        return new PairingResultLazyGroupElement(this.gt, this, g1, g2);
    }

    @Override
    public boolean isSymmetric() {
        return this.impl.isSymmetric();
    }

    public String toString() {
        return this.impl.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyBilinearMap that = (LazyBilinearMap)o;
        return this.impl.equals(that.impl) && this.g1.equals(that.g1) && this.g2.equals(that.g2) && this.gt.equals(that.gt);
    }

    public int hashCode() {
        return Objects.hash(this.impl);
    }

    public BilinearMapImpl getImpl() {
        return this.impl;
    }
}

