/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.lazy;

import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.cryptimeleon.math.hash.ByteAccumulator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.exp.Multiexponentiation;
import org.cryptimeleon.math.structures.groups.exp.SmallExponentPrecomputation;
import org.cryptimeleon.math.structures.groups.lazy.ExpLazyGroupElement;
import org.cryptimeleon.math.structures.groups.lazy.InvLazyGroupElement;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.OpLazyGroupElement;

public abstract class LazyGroupElement
implements GroupElement {
    protected LazyGroup group;
    private GroupElementImpl concreteValue = null;
    private volatile ComputationState computationState = ComputationState.NOTHING;
    private CompletableFuture<GroupElement> futureConcreteValue = null;
    private SmallExponentPrecomputation precomputedSmallExponents = null;

    public LazyGroupElement(LazyGroup group) {
        this.group = group;
    }

    public LazyGroupElement(LazyGroup group, GroupElementImpl concreteValue) {
        this(group);
        this.setConcreteValue(concreteValue);
    }

    @Override
    public Group getStructure() {
        return this.group;
    }

    @Override
    public GroupElement inv() {
        return new InvLazyGroupElement(this.group, this);
    }

    @Override
    public GroupElement op(Element e) throws IllegalArgumentException {
        if (!(e instanceof LazyGroupElement) || !((LazyGroupElement)e).group.equals(this.group)) {
            throw new IllegalArgumentException("Groups don't match: " + this.group.toString() + " vs " + e.getStructure().toString());
        }
        return new OpLazyGroupElement(this.group, this, (LazyGroupElement)e);
    }

    @Override
    public GroupElement square() {
        return new OpLazyGroupElement(this.group, this, this);
    }

    @Override
    public GroupElement pow(BigInteger exponent) {
        return new ExpLazyGroupElement(this.group, this, exponent);
    }

    @Override
    public GroupElement precomputePow() {
        return this.precomputePow(this.group.precomputationWindowSize);
    }

    @Override
    public GroupElement precomputePow(int windowSize) {
        if (windowSize > 0) {
            this.getPrecomputedSmallExponents().compute(windowSize, this.getConcreteValue().getStructure().estimateCostInvPerOp() > 1.0);
            this.getPrecomputedSmallExponents().computeNegativePowers(windowSize, this.getConcreteValue().getStructure().estimateCostInvPerOp() > 1.0);
        }
        return this;
    }

    @Override
    public GroupElement compute() {
        if (this.computationState == ComputationState.NOTHING) {
            this.computationState = ComputationState.REQUESTED;
            LazyGroup.executor.submit(this::computeSync);
        }
        return this;
    }

    @Override
    public GroupElement computeSync() {
        this.getConcreteValue();
        return this;
    }

    protected void setConcreteValue(GroupElementImpl impl) {
        this.concreteValue = impl;
        this.computationState = ComputationState.DONE;
    }

    protected GroupElementImpl getConcreteValue() {
        if (this.computationState == ComputationState.IN_PROGRESS) {
            try {
                this.futureConcreteValue.get();
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        } else if (this.computationState != ComputationState.DONE) {
            this.futureConcreteValue = new CompletableFuture();
            this.computationState = ComputationState.IN_PROGRESS;
            this.computeConcreteValue();
            this.futureConcreteValue.complete(this);
        }
        return this.concreteValue;
    }

    protected boolean isDefinitelySupposedToGetConcreteValue() {
        return this.computationState != ComputationState.NOTHING;
    }

    protected abstract void computeConcreteValue();

    protected GroupElementImpl accumulateMultiexp(Multiexponentiation multiexp) {
        return this.getConcreteValue();
    }

    public SmallExponentPrecomputation getPrecomputedSmallExponents() {
        if (this.precomputedSmallExponents == null) {
            this.precomputedSmallExponents = new SmallExponentPrecomputation(this.getConcreteValue());
        }
        return this.precomputedSmallExponents;
    }

    @Override
    public boolean isComputed() {
        return this.computationState == ComputationState.DONE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LazyGroupElement)) {
            return false;
        }
        LazyGroupElement that = (LazyGroupElement)o;
        if (!this.group.equals(that.group)) {
            return false;
        }
        return this.getConcreteValue().equals(that.getConcreteValue());
    }

    @Override
    public boolean isNeutralElement() {
        return this.getConcreteValue().isNeutralElement();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.group, this.getConcreteValue());
    }

    @Override
    public ByteAccumulator updateAccumulator(ByteAccumulator accumulator) {
        this.getConcreteValue().updateAccumulator(accumulator);
        return accumulator;
    }

    @Override
    public Representation getRepresentation() {
        return this.getConcreteValue().getRepresentation();
    }

    public String toString() {
        if (this.computationState == ComputationState.DONE) {
            return this.concreteValue.toString();
        }
        return "LazyGroupElement{computationState=" + (Object)((Object)this.computationState) + '}';
    }

    protected static enum ComputationState {
        NOTHING,
        REQUESTED,
        IN_PROGRESS,
        DONE;

    }
}

