/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.lazy;

import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.lazy.HomomorphismResultLazyGroupElement;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroupElement;
import org.cryptimeleon.math.structures.groups.mappings.GroupHomomorphism;
import org.cryptimeleon.math.structures.groups.mappings.impl.GroupHomomorphismImpl;

public class LazyGroupHomomorphism
implements GroupHomomorphism {
    @Represented
    protected LazyGroup targetGroup;
    @Represented
    protected GroupHomomorphismImpl impl;

    public LazyGroupHomomorphism(LazyGroup targetGroup, GroupHomomorphismImpl homomorphismImpl) {
        this.targetGroup = targetGroup;
        this.impl = homomorphismImpl;
    }

    public LazyGroupHomomorphism(Representation repr) {
        ReprUtil.deserialize(this, repr);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    @Override
    public HomomorphismResultLazyGroupElement apply(GroupElement groupElement) {
        return new HomomorphismResultLazyGroupElement((LazyGroupElement)groupElement, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyGroupHomomorphism that = (LazyGroupHomomorphism)o;
        return this.impl.equals(that.impl);
    }

    public int hashCode() {
        return Objects.hash(this.impl);
    }

    public LazyGroup getTargetGroup() {
        return this.targetGroup;
    }
}

