/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.lazy;

import java.util.List;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.exp.MultiExpTerm;
import org.cryptimeleon.math.structures.groups.exp.Multiexponentiation;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroup;
import org.cryptimeleon.math.structures.groups.lazy.LazyGroupElement;

public class OpLazyGroupElement
extends LazyGroupElement {
    LazyGroupElement lhs;
    LazyGroupElement rhs;
    GroupElementImpl accumulatedConstant = null;
    List<MultiExpTerm> terms = null;
    int firstTermIndex = -1;
    int lastTermIndex = -1;

    public OpLazyGroupElement(LazyGroup group, LazyGroupElement lhs, LazyGroupElement rhs) {
        super(group);
        this.lhs = lhs;
        this.rhs = rhs;
    }

    @Override
    protected void computeConcreteValue() {
        Multiexponentiation multiexp = new Multiexponentiation();
        multiexp.put(this.accumulateMultiexp(multiexp));
        this.setConcreteValue(this.group.compute(multiexp));
    }

    @Override
    protected GroupElementImpl accumulateMultiexp(Multiexponentiation multiexp) {
        GroupElementImpl rhsConstant;
        if (this.isComputed()) {
            return this.getConcreteValue();
        }
        if (this.terms != null) {
            for (int i = this.firstTermIndex; i <= this.lastTermIndex; ++i) {
                multiexp.put(this.terms.get(i));
            }
            return this.accumulatedConstant;
        }
        this.firstTermIndex = multiexp.getNumberOfTerms();
        GroupElementImpl lhsConstant = this.lhs.isDefinitelySupposedToGetConcreteValue() ? this.lhs.getConcreteValue() : this.lhs.accumulateMultiexp(multiexp);
        GroupElementImpl groupElementImpl = rhsConstant = this.rhs.isDefinitelySupposedToGetConcreteValue() ? this.rhs.getConcreteValue() : this.rhs.accumulateMultiexp(multiexp);
        this.accumulatedConstant = lhsConstant == null ? rhsConstant : (rhsConstant == null ? lhsConstant : lhsConstant.op(rhsConstant));
        this.lastTermIndex = multiexp.getNumberOfTerms() - 1;
        if (this.firstTermIndex <= this.lastTermIndex) {
            this.terms = multiexp.getTerms();
        } else if (this.accumulatedConstant != null) {
            this.setConcreteValue(this.accumulatedConstant);
        } else {
            this.setConcreteValue(this.group.impl.getNeutralElement());
        }
        return this.accumulatedConstant;
    }
}

