/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.rings.zn;

import java.math.BigInteger;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.structures.Element;
import org.cryptimeleon.math.structures.rings.Field;
import org.cryptimeleon.math.structures.rings.FieldElement;
import org.cryptimeleon.math.structures.rings.helpers.FiniteFieldTools;
import org.cryptimeleon.math.structures.rings.zn.Zn;

public class Zp
extends Zn
implements Field {
    public Zp(BigInteger p) {
        super(p);
        if (!p.isProbablePrime(100)) {
            throw new IllegalArgumentException(p + " is not prime.");
        }
    }

    public Zp(Representation repr) {
        super(repr);
        if (!this.n.isProbablePrime(100)) {
            throw new IllegalArgumentException(this.n + " is not prime");
        }
    }

    @Override
    public BigInteger sizeUnitGroup() {
        return this.n.subtract(BigInteger.ONE);
    }

    @Override
    public boolean hasPrimeSize() throws UnsupportedOperationException {
        return true;
    }

    @Override
    public ZpElement getUniformlyRandomUnit() throws UnsupportedOperationException {
        return this.createZnElement(RandomGenerator.getRandomNumber(BigInteger.ONE, this.n));
    }

    @Override
    public ZpElement getUniformlyRandomNonzeroElement() {
        return (ZpElement)super.getUniformlyRandomNonzeroElement();
    }

    @Override
    public ZpElement getUniformlyRandomElement() throws UnsupportedOperationException {
        return (ZpElement)super.getUniformlyRandomElement();
    }

    @Override
    public ZpElement getOneElement() {
        return (ZpElement)super.getOneElement();
    }

    @Override
    public ZpElement getZeroElement() {
        return (ZpElement)super.getZeroElement();
    }

    @Override
    public ZpElement getPrimitiveElement() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ZpElement restoreElement(Representation repr) {
        return (ZpElement)super.restoreElement(repr);
    }

    @Override
    public ZpElement getElement(long i) {
        return (ZpElement)super.getElement(i);
    }

    @Override
    public ZpElement createZnElement(BigInteger v) {
        return this.createZnElementUnsafe(v.mod(this.n));
    }

    @Override
    protected ZpElement createZnElementUnsafe(BigInteger vBetween0andN) {
        return new ZpElement(vBetween0andN);
    }

    @Override
    public ZpElement getElement(BigInteger i) {
        return this.createZnElement(i);
    }

    @Override
    public ZpElement injectiveValueOf(byte[] bytes) throws IllegalArgumentException {
        return (ZpElement)super.injectiveValueOf(bytes);
    }

    public static ZpElement valueOf(BigInteger representative, BigInteger modulus) {
        Zp zp = new Zp(modulus);
        zp.getClass();
        return zp.new ZpElement(representative);
    }

    public static ZpElement valueOf(long representative, BigInteger modulus) {
        return Zp.valueOf(BigInteger.valueOf(representative), modulus);
    }

    public static ZpElement valueOf(long representative, long modulus) {
        return Zp.valueOf(representative, BigInteger.valueOf(modulus));
    }

    @Override
    public ZpElement valueOf(long representative) {
        return this.valueOf(BigInteger.valueOf(representative));
    }

    @Override
    public ZpElement valueOf(BigInteger representative) {
        return this.createZnElement(representative);
    }

    public class ZpElement
    extends Zn.ZnElement
    implements FieldElement {
        public ZpElement(BigInteger v) {
            super(Zp.this, v);
        }

        @Override
        public Zp getStructure() {
            return Zp.this;
        }

        @Override
        public ZpElement add(Element e) {
            return (ZpElement)super.add(e);
        }

        @Override
        public ZpElement sub(Element e) {
            return (ZpElement)super.sub(e);
        }

        @Override
        public ZpElement neg() {
            return (ZpElement)super.neg();
        }

        @Override
        public ZpElement mul(Element e) {
            return (ZpElement)super.mul(e);
        }

        @Override
        public ZpElement mul(BigInteger k) {
            return (ZpElement)super.mul(k);
        }

        @Override
        public ZpElement mul(long k) {
            return (ZpElement)super.mul(k);
        }

        @Override
        public ZpElement inv() throws UnsupportedOperationException {
            return (ZpElement)super.inv();
        }

        @Override
        public ZpElement pow(BigInteger k) {
            return (ZpElement)super.pow(k);
        }

        @Override
        public ZpElement pow(long k) {
            return (ZpElement)super.pow(k);
        }

        public boolean isSquare() {
            return FiniteFieldTools.isSquare(this);
        }

        public ZpElement sqrt() throws ArithmeticException {
            ZpElement result;
            if (this.isZero()) {
                return this;
            }
            BigInteger p = Zp.this.n;
            int pMod8 = p.mod(BigInteger.valueOf(8L)).intValue();
            if (1 != pMod8) {
                if (3 == pMod8 % 4) {
                    result = this.pow(p.add(BigInteger.ONE).divide(BigInteger.valueOf(4L)));
                } else if (5 == pMod8) {
                    ZpElement t;
                    result = this.pow(p.add(BigInteger.valueOf(3L)).divide(BigInteger.valueOf(8L)));
                    if (result.mul(t = this.pow(p.subtract(BigInteger.valueOf(5L)).divide(BigInteger.valueOf(8L)))).neg().isOne()) {
                        result = Zp.this.createZnElement(BigInteger.valueOf(4L)).pow(p.subtract(BigInteger.valueOf(5L)).divide(BigInteger.valueOf(8L)));
                        result = result.mul(t);
                        result = result.mul(this);
                        result = result.add(result);
                    }
                } else {
                    result = Zp.this.getOneElement();
                }
            } else {
                result = this.isSquare() ? (ZpElement)FiniteFieldTools.sqrt(this) : Zp.this.getZeroElement();
            }
            if (result.square().equals(this)) {
                return result;
            }
            throw new ArithmeticException("Input has to be quadratic residue.");
        }

        @Override
        public FieldElement applyFrobenius() {
            return this;
        }
    }
}

