/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.annotations;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.rings.RingElement;
import org.cryptimeleon.math.structures.rings.zn.Zn;
import org.cryptimeleon.math.structures.rings.zn.Zp;
import org.junit.Assert;
import org.junit.Test;

public class ReprUtilTest {
    @Represented(restorer="(Str -> R) -> [Str]")
    HashMap<Map<String, RingElement>, List<String>> nestedMap;
    @Represented(restorer="foo::getFoo::getZp")
    Zp.ZpElement zpelem;
    @Represented
    Foo foo;

    @Test
    public void testNestedMap() {
        Zn ring = new Zn(BigInteger.TEN);
        HashMap nestedMapOriginal = new HashMap();
        HashMap<String, RingElement> inner = new HashMap<String, RingElement>();
        inner.put("testInner", ring.getUniformlyRandomElement());
        this.nestedMap = nestedMapOriginal;
        nestedMapOriginal.put(inner, Arrays.asList("testOuter", "testOuter2"));
        this.foo = new Foo(new Zp(BigInteger.valueOf(3L)));
        this.zpelem = Zp.valueOf((long)2L, (long)3L);
        Representation repr = ReprUtil.serialize((Object)this);
        this.nestedMap = null;
        this.zpelem = null;
        this.foo = null;
        new ReprUtil((Object)this).register((RepresentationRestorer)ring, "R").deserialize(repr);
        Assert.assertEquals(nestedMapOriginal, this.nestedMap);
        Assert.assertEquals((Object)Zp.valueOf((long)2L, (long)3L), (Object)this.zpelem);
    }

    public static class Foo
    implements StandaloneRepresentable {
        @Represented
        Zp zp;

        public Foo() {
            this(new Zp(BigInteger.valueOf(17L)));
        }

        public Foo(Zp zp) {
            this.zp = zp;
        }

        public Foo(Representation repr) {
            ReprUtil.deserialize((Object)this, (Representation)repr);
        }

        public Zp getZp() {
            return new Zp(BigInteger.valueOf(3L));
        }

        public Foo getFoo() {
            return this;
        }

        public Representation getRepresentation() {
            return ReprUtil.serialize((Object)this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Foo foo = (Foo)o;
            return Objects.equals(this.zp, foo.zp);
        }

        public int hashCode() {
            return Objects.hash(this.zp);
        }
    }
}

