/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.standalone;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.StandaloneRepresentable;
import org.junit.jupiter.api.Assertions;

public abstract class StandaloneReprSubTest {
    private HashSet<Class<? extends StandaloneRepresentable>> testedClasses;

    protected final void test(StandaloneRepresentable object) {
        Constructor<?> constructor;
        Class<?> clazz = object.getClass();
        this.testedClasses.add(clazz);
        try {
            constructor = clazz.getConstructor(Representation.class);
            Assertions.assertNotNull(constructor, (String)"Constructor is null");
        }
        catch (NoSuchMethodException | SecurityException e) {
            Assertions.fail((String)(clazz.getName() + " has no public constructor with a single Representation parameter"));
        }
        try {
            Method equals = clazz.getMethod("equals", Object.class);
            Assertions.assertNotEquals(equals.getDeclaringClass(), Object.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            Assertions.fail((String)(clazz.getName() + " does not override equals(Object)"));
        }
        try {
            Method hashCode = clazz.getMethod("hashCode", new Class[0]);
            Assertions.assertNotEquals(hashCode.getDeclaringClass(), Object.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            Assertions.fail((String)(clazz.getName() + " does not override hashCode()"));
        }
        try {
            constructor = clazz.getConstructor(Representation.class);
            Assertions.assertNotNull(constructor);
            Representation repr = (Representation)clazz.getMethod("getRepresentation", new Class[0]).invoke((Object)object, new Object[0]);
            Assertions.assertEquals((Object)object, constructor.newInstance(repr));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            Assertions.fail((String)("An error occured while serializing/deserializing " + clazz.getName()), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Assertions.fail((String)("An exception was thrown while serializing/deserializing " + clazz.getName()), (Throwable)e.getCause());
        }
    }

    public final Set<Class<? extends StandaloneRepresentable>> runTests() {
        Method[] declaredMethods;
        this.testedClasses = new HashSet();
        for (Method method : declaredMethods = this.getClass().getDeclaredMethods()) {
            try {
                if (method.getParameterCount() != 0 || Modifier.isStatic(method.getModifiers()) || Modifier.isPrivate(method.getModifiers())) continue;
                method.invoke((Object)this, new Object[0]);
            }
            catch (IllegalAccessException e) {
                Assertions.fail((Throwable)e);
            }
            catch (InvocationTargetException e) {
                Assertions.fail((String)("Exception thrown during execution of " + this.getClass().getName() + "::" + method.getName()), (Throwable)e.getCause());
            }
        }
        return this.testedClasses;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

