/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.random;

import java.math.BigInteger;

public interface RandomGeneratorImpl {
    default public BigInteger getRandomNumber(BigInteger exclusiveUpperBound) {
        byte[] random_bytes;
        BigInteger result;
        int n = exclusiveUpperBound.subtract(BigInteger.ONE).bitLength();
        int byte_length = ++n / 8;
        if (0 != n % 8) {
            ++byte_length;
        }
        int mask = 127;
        if (0 != n % 8) {
            mask = (byte)(mask >> 8 - n % 8);
        }
        do {
            random_bytes = this.getRandomBytes(byte_length);
            random_bytes[0] = (byte)(random_bytes[0] & mask);
        } while ((result = new BigInteger(random_bytes)).compareTo(exclusiveUpperBound) >= 0);
        return result;
    }

    default public BigInteger getRandomNumber(BigInteger inclusiveLowerBound, BigInteger exclusiveUpperBound) {
        return this.getRandomNumber(exclusiveUpperBound.subtract(inclusiveLowerBound)).add(inclusiveLowerBound);
    }

    default public BigInteger getRandomNumberOfBitlength(int bitlength) {
        return this.getRandomNumber(BigInteger.ONE.shiftLeft(bitlength));
    }

    public byte[] getRandomBytes(int var1);

    default public boolean getRandomBit() {
        return this.getRandomBytes(1)[0] % 2 == 0;
    }

    default public BigInteger getRandomPrime(int bitlength) {
        BigInteger candidate;
        BigInteger lowerBound = BigInteger.ONE.shiftLeft(bitlength - 1);
        BigInteger upperBound = BigInteger.ONE.shiftLeft(bitlength).subtract(BigInteger.ONE);
        while (!(candidate = this.getRandomNumber(lowerBound, upperBound)).isProbablePrime(128)) {
        }
        return candidate;
    }
}

