/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.random;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.cryptimeleon.math.random.RandomGeneratorImpl;

public class SecureRandomGeneratorImpl
implements RandomGeneratorImpl {
    protected SecureRandom rng = new SecureRandom();

    @Override
    public byte[] getRandomBytes(int l) {
        byte[] result = new byte[l];
        this.rng.nextBytes(result);
        return result;
    }

    @Override
    public boolean getRandomBit() {
        return this.rng.nextBoolean();
    }

    @Override
    public BigInteger getRandomPrime(int bitlength) {
        return BigInteger.probablePrime(bitlength, this.rng);
    }
}

