/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.serialization.annotations;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.function.Function;
import org.cryptimeleon.math.serialization.ListRepresentation;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.RepresentationHandler;
import org.cryptimeleon.math.serialization.annotations.RepresentationRestorer;

class ArrayRepresentationHandler
implements RepresentationHandler {
    protected RepresentationHandler elementHandler;
    protected Class<?> elementType;

    public ArrayRepresentationHandler(RepresentationHandler elementHandler, Type typeofArray) {
        this.elementHandler = elementHandler;
        this.elementType = ArrayRepresentationHandler.getTypeOfElements(typeofArray);
    }

    public static Class<?> getTypeOfElements(Type typeOfArray) {
        return ((Class)typeOfArray).getComponentType();
    }

    public static boolean canHandle(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class arrayType = (Class)type;
        return arrayType.isArray();
    }

    @Override
    public Object deserializeFromRepresentation(Representation repr, Function<String, RepresentationRestorer> getRegisteredRestorer) {
        if (repr == null) {
            return null;
        }
        Object result = Array.newInstance(this.elementType, repr.list().size());
        int i = 0;
        for (Representation inner : repr.list()) {
            Array.set(result, i++, this.elementHandler.deserializeFromRepresentation(inner, getRegisteredRestorer));
        }
        return result;
    }

    @Override
    public Representation serializeToRepresentation(Object obj) {
        if (obj == null) {
            return null;
        }
        ListRepresentation repr = new ListRepresentation();
        for (int i = 0; i < Array.getLength(obj); ++i) {
            repr.put(this.elementHandler.serializeToRepresentation(Array.get(obj, i)));
        }
        return repr;
    }
}

