/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.cartesian;

import java.math.BigInteger;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.cryptimeleon.math.expressions.exponent.ExponentExpr;
import org.cryptimeleon.math.expressions.group.GroupElementExpression;
import org.cryptimeleon.math.expressions.group.GroupEmptyExpr;
import org.cryptimeleon.math.structures.cartesian.Vector;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.rings.RingElement;

public class GroupElementExpressionVector
extends Vector<GroupElementExpression> {
    public GroupElementExpressionVector(GroupElementExpression ... values) {
        super(values);
    }

    public GroupElementExpressionVector(List<GroupElementExpression> values) {
        super(values);
    }

    public GroupElementExpressionVector(Vector<? extends GroupElementExpression> vector) {
        this(vector.values, true);
    }

    protected GroupElementExpressionVector(GroupElementExpression[] values, boolean isSafe) {
        super((X[])values, isSafe);
    }

    protected GroupElementExpressionVector(List<? extends GroupElementExpression> values, boolean isSafe) {
        super(values, isSafe);
    }

    public GroupElementExpressionVector op(Vector<? extends GroupElementExpression> other) {
        return this.zip(other, GroupElementExpression::op, GroupElementExpressionVector::instantiateWithSafeArray);
    }

    public GroupElementExpressionVector op(GroupElement elem) {
        return this.map((X g) -> g.op(elem), GroupElementExpressionVector::instantiateWithSafeArray);
    }

    public GroupElementExpressionVector pow(BigInteger exponent) {
        return this.map((X g) -> g.pow(exponent), GroupElementExpressionVector::instantiateWithSafeArray);
    }

    public GroupElementExpressionVector pow(long exponent) {
        return this.map((X g) -> g.pow(exponent), GroupElementExpressionVector::instantiateWithSafeArray);
    }

    public GroupElementExpressionVector pow(RingElement exponent) {
        return this.map((X g) -> g.pow(exponent), GroupElementExpressionVector::instantiateWithSafeArray);
    }

    public GroupElementExpressionVector pow(ExponentExpr exponent) {
        return this.map((X g) -> g.pow(exponent), GroupElementExpressionVector::instantiateWithSafeArray);
    }

    public GroupElementExpressionVector pow(Vector<?> exponents) {
        return this.zip(exponents, GroupElementExpressionVector::exponentiateWithObject, GroupElementExpressionVector::instantiateWithSafeArray);
    }

    public GroupElementExpression innerProduct(Vector<?> other, GroupElementExpression neutralElement) {
        return this.zipReduce(other, GroupElementExpressionVector::exponentiateWithObject, GroupElementExpression::op, neutralElement);
    }

    public GroupElementExpression innerProduct(Vector<?> other) {
        return this.zipReduce(other, GroupElementExpressionVector::exponentiateWithObject, GroupElementExpression::op, new GroupEmptyExpr());
    }

    protected static GroupElementExpression exponentiateWithObject(GroupElementExpression g, Object exp) {
        if (exp instanceof BigInteger) {
            return g.pow((BigInteger)exp);
        }
        if (exp instanceof RingElement) {
            return g.pow((RingElement)exp);
        }
        if (exp instanceof Long) {
            return g.pow((Long)exp);
        }
        if (exp instanceof ExponentExpr) {
            return g.pow((ExponentExpr)exp);
        }
        throw new IllegalArgumentException("Cannot compute g^" + exp.getClass().getName());
    }

    public GroupElementExpression innerProduct(Vector<? extends GroupElementExpression> rightHandSide, BilinearMap bilinearMap) {
        return this.zipReduce(rightHandSide, bilinearMap::applyExpr, GroupElementExpression::op, bilinearMap.getGT().expr());
    }

    static GroupElementExpressionVector instantiateWithSafeArray(List<? extends GroupElementExpression> array) {
        return new GroupElementExpressionVector(array, true);
    }

    public static GroupElementExpressionVector iterate(GroupElementExpression initialValue, Function<GroupElementExpression, GroupElementExpression> nextValue, int n) {
        return Vector.iterate(initialValue, nextValue, n, GroupElementExpressionVector::instantiateWithSafeArray);
    }

    public static GroupElementExpressionVector generate(Function<Integer, ? extends GroupElementExpression> generator, int n) {
        return GroupElementExpressionVector.generatePlain(generator, n, GroupElementExpressionVector::instantiateWithSafeArray);
    }

    public static GroupElementExpressionVector generate(Supplier<? extends GroupElementExpression> generator, int n) {
        return GroupElementExpressionVector.generatePlain(generator, n, GroupElementExpressionVector::instantiateWithSafeArray);
    }

    public static GroupElementExpressionVector of(GroupElementExpression ... vals) {
        return new GroupElementExpressionVector(vals, false);
    }

    public GroupElementExpressionVector pad(GroupElementExpression valueToPadWith, int desiredLength) {
        return new GroupElementExpressionVector((Vector<? extends GroupElementExpression>)super.pad(valueToPadWith, desiredLength));
    }

    public GroupElementExpressionVector append(GroupElementExpression valueToAppend) {
        return new GroupElementExpressionVector((Vector<? extends GroupElementExpression>)super.append(valueToAppend));
    }

    public GroupElementExpressionVector prepend(GroupElementExpression valueToPrepend) {
        return new GroupElementExpressionVector((Vector<? extends GroupElementExpression>)super.prepend(valueToPrepend));
    }

    public GroupElementExpressionVector replace(int index, GroupElementExpression substitute) {
        return new GroupElementExpressionVector((Vector<? extends GroupElementExpression>)super.replace(index, substitute));
    }

    public GroupElementExpressionVector truncate(int newLength) {
        return new GroupElementExpressionVector(super.truncate(newLength));
    }

    public GroupElementExpressionVector concatenate(Vector<? extends GroupElementExpression> secondPart) {
        return new GroupElementExpressionVector(super.concatenate(secondPart));
    }

    public static GroupElementExpressionVector fromStream(Stream<? extends GroupElementExpression> stream) {
        return GroupElementExpressionVector.fromStreamPlain(stream, GroupElementExpressionVector::instantiateWithSafeArray);
    }
}

