/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.basic;

import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.HashIntoGroup;
import org.cryptimeleon.math.structures.groups.basic.BasicBilinearMap;
import org.cryptimeleon.math.structures.groups.basic.BasicGroup;
import org.cryptimeleon.math.structures.groups.basic.BasicGroupHomomorphism;
import org.cryptimeleon.math.structures.groups.basic.HashIntoBasicGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.groups.mappings.GroupHomomorphism;

public class BasicBilinearGroup
implements BilinearGroup {
    @Represented
    protected BilinearGroupImpl impl;
    BasicGroup g1;
    BasicGroup g2;
    BasicGroup gt;
    BasicGroupHomomorphism homG2toG1;
    BilinearMap map;
    HashIntoGroup hashIntoG1;
    HashIntoGroup hashIntoG2;
    HashIntoGroup hashIntoGt;

    public BasicBilinearGroup(BilinearGroupImpl impl) {
        this.impl = impl;
        this.instantiateBasicStuff();
    }

    public BasicBilinearGroup(Representation repr) {
        ReprUtil.deserialize(this, repr);
        this.instantiateBasicStuff();
    }

    protected void instantiateBasicStuff() {
        this.g1 = new BasicGroup(this.impl.getG1());
        this.g2 = new BasicGroup(this.impl.getG2());
        this.gt = new BasicGroup(this.impl.getGT());
        this.map = new BasicBilinearMap(this.g1, this.g2, this.gt, this.impl.getBilinearMap());
        try {
            this.homG2toG1 = new BasicGroupHomomorphism(this.g1, this.impl.getHomomorphismG2toG1());
        }
        catch (UnsupportedOperationException e) {
            this.homG2toG1 = null;
        }
        try {
            this.hashIntoG1 = new HashIntoBasicGroup(this.impl.getHashIntoG1(), this.g1);
        }
        catch (UnsupportedOperationException e) {
            this.hashIntoG1 = null;
        }
        try {
            this.hashIntoG2 = new HashIntoBasicGroup(this.impl.getHashIntoG2(), this.g2);
        }
        catch (UnsupportedOperationException e) {
            this.hashIntoG2 = null;
        }
        try {
            this.hashIntoGt = new HashIntoBasicGroup(this.impl.getHashIntoGT(), this.gt);
        }
        catch (UnsupportedOperationException e) {
            this.hashIntoGt = null;
        }
    }

    @Override
    public BasicGroup getG1() {
        return this.g1;
    }

    @Override
    public BasicGroup getG2() {
        return this.g2;
    }

    @Override
    public BasicGroup getGT() {
        return this.gt;
    }

    @Override
    public BilinearMap getBilinearMap() {
        return this.map;
    }

    @Override
    public GroupHomomorphism getHomomorphismG2toG1() throws UnsupportedOperationException {
        if (this.homG2toG1 == null) {
            throw new UnsupportedOperationException("No homomorphism available");
        }
        return this.homG2toG1;
    }

    @Override
    public HashIntoGroup getHashIntoG1() throws UnsupportedOperationException {
        if (this.hashIntoG1 == null) {
            throw new UnsupportedOperationException("No hash available");
        }
        return this.hashIntoG1;
    }

    @Override
    public HashIntoGroup getHashIntoG2() throws UnsupportedOperationException {
        if (this.hashIntoG2 == null) {
            throw new UnsupportedOperationException("No hash available");
        }
        return this.hashIntoG2;
    }

    @Override
    public HashIntoGroup getHashIntoGT() throws UnsupportedOperationException {
        if (this.hashIntoGt == null) {
            throw new UnsupportedOperationException("No hash available");
        }
        return this.hashIntoGt;
    }

    @Override
    public Integer getSecurityLevel() {
        return this.impl.getSecurityLevel();
    }

    @Override
    public BilinearGroup.Type getPairingType() {
        return this.impl.getPairingType();
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicBilinearGroup that = (BasicBilinearGroup)o;
        return this.impl.equals(that.impl);
    }

    public int hashCode() {
        return Objects.hash(this.impl);
    }
}

