/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.basic;

import java.math.BigInteger;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.basic.BasicGroup;
import org.cryptimeleon.math.structures.groups.basic.BasicGroupElement;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMapImpl;

public class BasicBilinearMap
implements BilinearMap {
    protected BasicGroup g1;
    protected BasicGroup g2;
    protected BasicGroup gt;
    protected BilinearMapImpl impl;

    public BasicBilinearMap(BasicGroup g1, BasicGroup g2, BasicGroup gt, BilinearMapImpl impl) {
        this.g1 = g1;
        this.g2 = g2;
        this.gt = gt;
        this.impl = impl;
    }

    @Override
    public Group getG1() {
        return this.g1;
    }

    @Override
    public Group getG2() {
        return this.g2;
    }

    @Override
    public Group getGT() {
        return this.gt;
    }

    @Override
    public BasicGroupElement apply(GroupElement g1, GroupElement g2, BigInteger exponent) {
        return this.gt.wrap(this.impl.apply(((BasicGroupElement)g1).impl, ((BasicGroupElement)g2).impl, exponent));
    }

    @Override
    public boolean isSymmetric() {
        return this.impl.isSymmetric();
    }

    public String toString() {
        return "BasicBilinearMap{impl=" + this.impl + '}';
    }
}

