/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.basic;

import java.util.Objects;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.GroupElement;
import org.cryptimeleon.math.structures.groups.GroupElementImpl;
import org.cryptimeleon.math.structures.groups.basic.BasicGroup;
import org.cryptimeleon.math.structures.groups.basic.BasicGroupElement;
import org.cryptimeleon.math.structures.groups.mappings.GroupHomomorphism;
import org.cryptimeleon.math.structures.groups.mappings.impl.GroupHomomorphismImpl;

public class BasicGroupHomomorphism
implements GroupHomomorphism {
    @Represented
    protected BasicGroup targetGroup;
    @Represented
    protected GroupHomomorphismImpl impl;

    public BasicGroupHomomorphism(BasicGroup targetGroup, GroupHomomorphismImpl homomorphismImpl) {
        this.targetGroup = targetGroup;
        this.impl = homomorphismImpl;
    }

    public BasicGroupHomomorphism(Representation repr) {
        ReprUtil.deserialize(this, repr);
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    @Override
    public GroupElement apply(GroupElement groupElement) {
        return this.targetGroup.wrap((GroupElementImpl)this.impl.apply(((BasicGroupElement)groupElement).impl));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicGroupHomomorphism that = (BasicGroupHomomorphism)o;
        return this.targetGroup.equals(that.targetGroup) && this.impl.equals(that.impl);
    }

    public int hashCode() {
        return Objects.hash(this.impl);
    }
}

