/*
 * Decompiled with CFR 0.152.
 */
package org.cryptimeleon.math.structures.groups.debug;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Objects;
import org.cryptimeleon.math.random.RandomGenerator;
import org.cryptimeleon.math.serialization.Representation;
import org.cryptimeleon.math.serialization.annotations.ReprUtil;
import org.cryptimeleon.math.serialization.annotations.Represented;
import org.cryptimeleon.math.structures.groups.Group;
import org.cryptimeleon.math.structures.groups.HashIntoGroup;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearGroupImpl;
import org.cryptimeleon.math.structures.groups.debug.DebugBilinearMap;
import org.cryptimeleon.math.structures.groups.debug.DebugGroup;
import org.cryptimeleon.math.structures.groups.debug.DebugHomomorphism;
import org.cryptimeleon.math.structures.groups.debug.HashIntoDebugGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearGroup;
import org.cryptimeleon.math.structures.groups.elliptic.BilinearMap;
import org.cryptimeleon.math.structures.groups.lazy.LazyBilinearGroup;
import org.cryptimeleon.math.structures.groups.mappings.GroupHomomorphism;

public class DebugBilinearGroup
implements BilinearGroup {
    @Represented
    protected Integer securityParameter;
    @Represented
    protected BilinearGroup.Type pairingType;
    @Represented
    protected LazyBilinearGroup totalBilGroup;
    @Represented
    protected LazyBilinearGroup expMultiExpBilGroup;
    protected DebugBilinearMap bilMap;

    public DebugBilinearGroup(int securityParameter, BilinearGroup.Type pairingType, int numPrimeFactors) {
        this.securityParameter = securityParameter;
        this.pairingType = pairingType;
        ArrayList<BigInteger> primeFactors = new ArrayList<BigInteger>();
        for (int i = 0; i < numPrimeFactors; ++i) {
            primeFactors.add(RandomGenerator.getRandomPrime(securityParameter));
        }
        BigInteger size = primeFactors.stream().reduce(BigInteger.ONE, BigInteger::multiply);
        this.totalBilGroup = new LazyBilinearGroup(new DebugBilinearGroupImpl(securityParameter, pairingType, size, false, false));
        this.expMultiExpBilGroup = new LazyBilinearGroup(new DebugBilinearGroupImpl(securityParameter, pairingType, size, true, true));
        this.init();
    }

    public DebugBilinearGroup(int securityParameter, BilinearGroup.Type pairingType) {
        this(securityParameter, pairingType, 1);
    }

    public DebugBilinearGroup(BilinearGroup.Type pairingType) {
        this(128, pairingType);
    }

    public DebugBilinearGroup(Representation repr) {
        ReprUtil.deserialize(this, repr);
        this.init();
    }

    protected void init() {
        this.bilMap = new DebugBilinearMap(this.totalBilGroup.getBilinearMap(), this.expMultiExpBilGroup.getBilinearMap());
    }

    @Override
    public Group getG1() {
        return new DebugGroup(this.totalBilGroup.getG1(), this.expMultiExpBilGroup.getG1());
    }

    @Override
    public Group getG2() {
        return new DebugGroup(this.totalBilGroup.getG2(), this.expMultiExpBilGroup.getG2());
    }

    @Override
    public Group getGT() {
        return new DebugGroup(this.totalBilGroup.getGT(), this.expMultiExpBilGroup.getGT());
    }

    @Override
    public BilinearMap getBilinearMap() {
        return this.bilMap;
    }

    @Override
    public GroupHomomorphism getHomomorphismG2toG1() throws UnsupportedOperationException {
        if (this.pairingType != BilinearGroup.Type.TYPE_1 && this.pairingType != BilinearGroup.Type.TYPE_2) {
            throw new UnsupportedOperationException("Didn't require existence of a group homomorphism");
        }
        return new DebugHomomorphism(this.totalBilGroup.getHomomorphismG2toG1(), this.expMultiExpBilGroup.getHomomorphismG2toG1());
    }

    @Override
    public HashIntoGroup getHashIntoG1() throws UnsupportedOperationException {
        return new HashIntoDebugGroup(this.totalBilGroup.getHashIntoG1(), this.expMultiExpBilGroup.getHashIntoG1());
    }

    @Override
    public HashIntoGroup getHashIntoG2() throws UnsupportedOperationException {
        return new HashIntoDebugGroup(this.totalBilGroup.getHashIntoG2(), this.expMultiExpBilGroup.getHashIntoG2());
    }

    @Override
    public HashIntoGroup getHashIntoGT() throws UnsupportedOperationException {
        return new HashIntoDebugGroup(this.totalBilGroup.getHashIntoGT(), this.expMultiExpBilGroup.getHashIntoGT());
    }

    @Override
    public Integer getSecurityLevel() {
        return this.securityParameter;
    }

    @Override
    public BilinearGroup.Type getPairingType() {
        return this.pairingType;
    }

    @Override
    public Representation getRepresentation() {
        return ReprUtil.serialize(this);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DebugBilinearGroup that = (DebugBilinearGroup)other;
        return Objects.equals(this.totalBilGroup, that.totalBilGroup) && Objects.equals(this.expMultiExpBilGroup, that.expMultiExpBilGroup) && Objects.equals(this.bilMap, that.bilMap);
    }

    public int hashCode() {
        return Objects.hash(this.totalBilGroup, this.expMultiExpBilGroup, this.bilMap);
    }

    public long getNumPairings() {
        return this.bilMap.getNumPairings();
    }

    public void resetNumPairings() {
        this.bilMap.resetNumPairings();
    }

    public void resetCounters() {
        this.resetNumPairings();
        ((DebugGroup)this.getG1()).resetCounters();
        ((DebugGroup)this.getG2()).resetCounters();
        ((DebugGroup)this.getGT()).resetCounters();
    }

    public String formatCounterData() {
        return this.bilMap.formatCounterData();
    }
}

